/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.tools.ui.wizards;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionProperties;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.tools.ui.Activator;
import org.eclipse.egf.portfolio.genchain.tools.ui.Messages;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.EcoreModelPage;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.GenerationChainFactory;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.NewFilePage;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.Node;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class GenerationChainWizard
extends Wizard
implements INewWizard,
ExtensionProperties {
    private EcoreModelPage ecorePage;
    private NewFilePage filePage;
    private final Node model = new Node(0);
    private IStructuredSelection selection;
    private IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.filePage = new NewFilePage("newFile", this.selection);
        this.filePage.setTitle(Messages.genchain_wizard_title);
        this.filePage.setDescription(Messages.genchain_wizard_file_description);
        this.addPage((IWizardPage)this.filePage);
        this.ecorePage = new EcoreModelPage("ecore", this.model, this.selection);
        this.ecorePage.setTitle(Messages.genchain_wizard_title);
        this.ecorePage.setDescription(Messages.genchain_wizard_content_description);
        this.addPage((IWizardPage)this.ecorePage);
    }

    private EObject createInitialModel(IFile modelFile) {
        GenerationChain root = org.eclipse.egf.portfolio.genchain.generationChain.GenerationChainFactory.eINSTANCE.createGenerationChain();
        String name = modelFile.getName();
        String shortName = name.substring(0, name.indexOf(46));
        root.setName(shortName);
        root.setFactoryComponentName("org.eclipse.egf.chain." + shortName.toLowerCase());
        GenerationChainFactory.INSTANCE.createContainer(root, this.model, this.ecorePage.getCheckedElements());
        return root;
    }

    public boolean performFinish() {
        final IFile modelFile = this.filePage.getModelFile();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                        Resource resource = resourceSet.createResource(fileURI);
                        EObject rootObject = GenerationChainWizard.this.createInitialModel(modelFile);
                        if (rootObject != null) {
                            resource.getContents().add((Object)rootObject);
                        }
                        HashMap options = new HashMap();
                        resource.save(options);
                    }
                    catch (Exception exception) {
                        Activator.getDefault().logError(exception);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e);
            return false;
        }
        IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        try {
            page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
        }
        catch (PartInitException exception) {
            Activator.getDefault().logError(exception);
            return false;
        }
        return true;
    }
}

