/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build.buildscm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SVNProtocol implements Enumerator
{
    HTTP(0, "HTTP", "http://"),
    HTTPS(1, "HTTPS", "https://"),
    SVN(2, "SVN", "svn://"),
    SVNSSH(3, "SVNSSH", "svn+ssh://");

    public static final String copyright = "   Copyright (c) 2009-2010 Thales Corporate Services S.A.S.\r\n   All rights reserved. This program and the accompanying materials\r\n   are made available under the terms of the Eclipse Public License v1.0\r\n   which accompanies this distribution, and is available at\r\n   http://www.eclipse.org/legal/epl-v10.html\r\n  \r\n   Contributors:\r\n       Thales Corporate Services S.A.S - initial API and implementation";
    public static final int HTTP_VALUE = 0;
    public static final int HTTPS_VALUE = 1;
    public static final int SVN_VALUE = 2;
    public static final int SVNSSH_VALUE = 3;
    private static final SVNProtocol[] VALUES_ARRAY;
    public static final List<SVNProtocol> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SVNProtocol[]{HTTP, HTTPS, SVN, SVNSSH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SVNProtocol get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SVNProtocol result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SVNProtocol getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SVNProtocol result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SVNProtocol get(int value) {
        switch (value) {
            case 0: {
                return HTTP;
            }
            case 1: {
                return HTTPS;
            }
            case 2: {
                return SVN;
            }
            case 3: {
                return SVNSSH;
            }
        }
        return null;
    }

    private SVNProtocol(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

