/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsink;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;

@Path(value="close")
public class CloseResource {
    private static volatile boolean exception = false;
    private static volatile boolean isClosed = false;

    @GET
    @Path(value="reset")
    @Produces(value={"text/event-stream"})
    public void reset(@Context SseEventSink sink, @Context Sse sse) {
        exception = false;
        isClosed = false;
        try (SseEventSink s = sink;){
            s.send(sse.newEvent("RESET"));
        }
    }

    @GET
    @Path(value="send")
    @Produces(value={"text/event-stream"})
    public void send(final @Context SseEventSink sink, final @Context Sse sse) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                SseEventSink s = sink;
                s.send(sse.newEvent("some_ServiceUnavailableEndpoint_message"));
                s.close();
                isClosed = s.isClosed();
                if (!isClosed) {
                    return;
                }
                s.close();
                isClosed = s.isClosed();
                if (!isClosed) {
                    return;
                }
                s.close();
                isClosed = s.isClosed();
                if (!isClosed) {
                    return;
                }
                try {
                    s.send(sse.newEvent("SOMETHING"));
                }
                catch (IllegalStateException ise) {
                    exception = true;
                }
            }
        });
        t.start();
    }

    @GET
    @Path(value="check")
    @Produces(value={"text/event-stream"})
    public void check(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            if (!isClosed) {
                s.send(sse.newEvent("Not closed"));
                return;
            }
            if (!exception) {
                s.send(sse.newEvent("No IllegalStateException is thrown"));
                return;
            }
            s.send(sse.newEvent("CHECK"));
        }
    }

    @GET
    @Path(value="closed")
    @Produces(value={"text/plain"})
    public boolean isClosed() {
        return isClosed;
    }
}

