/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.ext.paramconverter;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.StringDataSource;
import ee.jakarta.tck.ws.rs.common.provider.PrintingErrorHandler;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.ee.rs.ext.paramconverter.AtomicIntegerLazyParamConverter;
import ee.jakarta.tck.ws.rs.ee.rs.ext.paramconverter.AtomicIntegerLazyParamConverterProvider;
import ee.jakarta.tck.ws.rs.ee.rs.ext.paramconverter.DataSourceParamConverter;
import ee.jakarta.tck.ws.rs.ee.rs.ext.paramconverter.DataSourceParamConverterProvider;
import ee.jakarta.tck.ws.rs.ee.rs.ext.paramconverter.Locator;
import ee.jakarta.tck.ws.rs.ee.rs.ext.paramconverter.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.ext.paramconverter.StringBeanParamConverter;
import ee.jakarta.tck.ws.rs.ee.rs.ext.paramconverter.StringBeanParamConverterProvider;
import ee.jakarta.tck.ws.rs.ee.rs.ext.paramconverter.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 863071027768369551L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_ext_paramconverter_web");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/ext/paramconverter/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_ext_paramconverter_web.war");
        archive.addClasses(new Class[]{Resource.class, Locator.class, DataSourceParamConverter.class, DataSourceParamConverterProvider.class, StringBeanParamConverter.class, StringBeanParamConverterProvider.class, AtomicIntegerLazyParamConverter.class, AtomicIntegerLazyParamConverterProvider.class, PrintingErrorHandler.class, StringBean.class, StringDataSource.class, TSAppConfig.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void isParamCoverterInApplicationSingletonsUsedTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "dsquery?param=", query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void isParamCoverterInApplicationClassesUsedTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "sbquery?param=", query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void atomicIntegerPassesTest() throws JAXRSCommonClient.Fault {
        String query = "10";
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "aiquery?param=", query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void atomicIntegerIsLazyDeployableAndThrowsErrorTest() throws JAXRSCommonClient.Fault {
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "aiquery");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }

    @Test
    public void pathParamUsesParamConvertorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "sbpath/", query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void matrixParamUsesParamConvertorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "sbmatrix;param=", query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void formParamUsesParamConvertorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.setPropertyRequest(JAXRSCommonClient.Request.POST, "sbform/");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "param=" + query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void cookieParamUsesParamConvertorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.buildCookie(query);
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "sbcookie");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void headerParamUsesParamConvertorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "param:" + query);
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "sbheader");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void defaultValueInQueryParamTest() throws JAXRSCommonClient.Fault {
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "sbquery");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    @Test
    public void defaultValueInMatrixParamTest() throws JAXRSCommonClient.Fault {
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "sbmatrix;");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    @Test
    public void defaultValueInPathParamTest() throws JAXRSCommonClient.Fault {
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "sbpath/default");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    @Test
    public void defaultValueInFormParamTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.setPropertyRequest(JAXRSCommonClient.Request.POST, "sbform/");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    @Test
    public void defaultValueInCookieParamTest() throws JAXRSCommonClient.Fault {
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "sbcookie");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    @Test
    public void defaultValueInHeaderParamTest() throws JAXRSCommonClient.Fault {
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "sbheader");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    @Test
    public void queryParamInLocatorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.GET, "sbquery/sbquery?param=", query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void defaultValueQueryParamInLocatorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.GET, "sbquery/sbquery?", query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    @Test
    public void pathParamInLocatorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.GET, "sbpath/sbpath/", query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void defaultValuePathParamInLocatorTest() throws JAXRSCommonClient.Fault {
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.GET, "sbpath/sbpath/default");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    @Test
    public void matrixParamInLocatorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.GET, "sbmatrix/sbmatrix;param=", query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void defaultValueMatrixParamInLocatorTest() throws JAXRSCommonClient.Fault {
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.GET, "sbmatrix/sbmatrix");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    @Test
    public void formParamInLocatorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.POST, "sbform/sbform");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "param=" + query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void defaultValueFormParamInLocatorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.POST, "sbform/sbform");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    @Test
    public void cookieParamInLocatorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.buildCookie(query);
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.GET, "sbcookie/sbcookie");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void defaultValueCookieParamInLocatorTest() throws JAXRSCommonClient.Fault {
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.GET, "sbcookie/sbcookie");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    @Test
    public void headerParamInLocatorTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "param:" + query);
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.GET, "sbheader/sbheader");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    @Test
    public void defaultValueHeaderParamInLocatorTest() throws JAXRSCommonClient.Fault {
        this.setPropertyRequestInLocator(JAXRSCommonClient.Request.GET, "sbheader/sbheader");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "DEFAULT");
        this.invoke();
    }

    private void setPropertyRequestInResource(JAXRSCommonClient.Request request, String ... resource) {
        StringBuilder sb = new StringBuilder("resource/");
        for (String r : resource) {
            sb.append(r);
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(request, sb.toString()));
    }

    private void setPropertyRequest(JAXRSCommonClient.Request request, String ... resource) {
        this.setPropertyRequestInResource(request, resource);
    }

    private void setPropertyRequestInLocator(JAXRSCommonClient.Request request, String ... resource) {
        StringBuilder sb = new StringBuilder("locator/");
        for (String r : resource) {
            sb.append(r);
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(request, sb.toString()));
    }

    private void buildCookie(String cookieValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cookie: param=").append(cookieValue);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, sb.toString());
    }
}

