/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.request;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

@Path(value="/RequestTest")
public class RequestTest {
    private static Response assertResponse(String expectedMethod, String actualMethod) {
        if (actualMethod.equalsIgnoreCase(expectedMethod)) {
            return Response.ok((Object)"Test PASSED").build();
        }
        return Response.ok((Object)("Test FAILED with " + actualMethod)).build();
    }

    @GET
    @Path(value="/GetMethodGetTest")
    public Response getTest(@Context Request req) {
        String method = req.getMethod();
        return RequestTest.assertResponse("GET", method);
    }

    @PUT
    @Path(value="/GetMethodPutTest")
    public Response putTest(@Context Request req) {
        String method = req.getMethod();
        return RequestTest.assertResponse("PUT", method);
    }

    @POST
    @Path(value="/GetMethodPostTest")
    public Response postTest(@Context Request req) {
        String method = req.getMethod();
        return RequestTest.assertResponse("POST", method);
    }

    @DELETE
    @Path(value="/GetMethodDeleteTest")
    public Response deleteTest(@Context Request req) {
        String method = req.getMethod();
        return RequestTest.assertResponse("DELETE", method);
    }

    @HEAD
    @Path(value="/GetMethodHeadTest")
    public Response headTest(@Context Request req) {
        String method = req.getMethod();
        if (method.equalsIgnoreCase("HEAD")) {
            return Response.ok().build();
        }
        return Response.status((int)400).build();
    }

    @GET
    @Path(value="/SelectVariantTestGet")
    public Response selectVariantTestGet(@Context Request req) {
        List vs = null;
        try {
            req.selectVariant(vs);
            return Response.ok((Object)"Test FAILED - no exception thrown").build();
        }
        catch (IllegalArgumentException ile) {
            return Response.ok((Object)"Test PASSED - expected exception thrown").build();
        }
        catch (Throwable th) {
            return Response.ok((Object)("Test FAILED - wrong type exception thrown" + th.getMessage())).build();
        }
    }

    @PUT
    @Path(value="/SelectVariantTestPut")
    public Response selectVariantTestPut(@Context Request req) {
        return this.selectVariantTestGet(req);
    }

    @POST
    @Path(value="/SelectVariantTestPost")
    public Response selectVariantTestPost(@Context Request req) {
        return this.selectVariantTestGet(req);
    }

    @DELETE
    @Path(value="/SelectVariantTestDelete")
    public Response selectVariantTestDelete(@Context Request req) {
        return this.selectVariantTestGet(req);
    }

    @GET
    @Path(value="/SelectVariantTestResponse")
    public Response selectVariantTestResponse(@Context Request req) {
        List list = Variant.encodings((String[])new String[]{"CP1250", "UTF-8"}).languages(new Locale[]{Locale.ENGLISH}).mediaTypes(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).add().build();
        Variant selectedVariant = req.selectVariant(list);
        if (null == selectedVariant) {
            return Response.notAcceptable((List)list).build();
        }
        return Response.ok((Object)"entity").build();
    }

    private static boolean evaluatePreconditionsEntityTagNull(Request req) {
        try {
            req.evaluatePreconditions((EntityTag)null);
            return false;
        }
        catch (IllegalArgumentException iae) {
            return true;
        }
    }

    private static boolean evaluatePreconditionsNowEntityTagNull(Request req) {
        try {
            Date now = Calendar.getInstance().getTime();
            req.evaluatePreconditions(now, (EntityTag)null);
            return false;
        }
        catch (IllegalArgumentException iae) {
            return true;
        }
    }

    private static boolean evaluatePreconditionsDateEntityTag(Request req, Date date, String tag) {
        Response.ResponseBuilder rb = req.evaluatePreconditions(date, RequestTest.createTag(tag));
        return rb == null;
    }

    private static boolean evaluatePreconditionsDate(Request req, Date date) {
        Response.ResponseBuilder rb = req.evaluatePreconditions(date);
        return rb == null;
    }

    private static boolean evaluatePreconditions(Request req) {
        Response.ResponseBuilder rb = req.evaluatePreconditions();
        return rb == null;
    }

    private static EntityTag createTag(String tag) {
        String xtag = "\"" + tag + "\"";
        return EntityTag.valueOf((String)xtag);
    }

    private static boolean evaluatePreconditionsEntityTag(Request req, String tag) {
        Response.ResponseBuilder rb = req.evaluatePreconditions(RequestTest.createTag(tag));
        return rb == null;
    }

    private static Response createResponse(boolean ok) {
        Response.Status status = ok ? Response.Status.OK : Response.Status.PRECONDITION_FAILED;
        return Response.status((Response.Status)status).build();
    }

    private static Date getYear1900() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 1900);
        return calendar.getTime();
    }

    @GET
    @Path(value="/preconditionsSimpleGet")
    public Response evaluatePreconditionsEntityTagGetSimpleTest(@Context Request req) {
        boolean ok = RequestTest.evaluatePreconditionsEntityTag(req, "AAA");
        if (!ok) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        if (!(ok &= RequestTest.evaluatePreconditionsNowEntityTagNull(req))) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        return RequestTest.createResponse(ok &= RequestTest.evaluatePreconditionsEntityTagNull(req));
    }

    @GET
    @Path(value="/preconditionsAAAGet")
    public Response evaluatePreconditionsEntityTagAAAGetTest(@Context Request req) {
        boolean ok = RequestTest.evaluatePreconditionsEntityTag(req, "AAA");
        return RequestTest.createResponse(ok);
    }

    @PUT
    @Path(value="/preconditionsAAAPut")
    public Response evaluatePreconditionsEntityTagAAAPutTest(@Context Request req) {
        return this.evaluatePreconditionsEntityTagAAAGetTest(req);
    }

    @HEAD
    @Path(value="/preconditionsAAAHead")
    public Response evaluatePreconditionsEntityTagAAAHeadTest(@Context Request req) {
        return this.evaluatePreconditionsEntityTagAAAGetTest(req);
    }

    @GET
    @Path(value="/preconditionsAAAAgesAgoGet")
    public Response evaluatePreconditionsAgesAgoEntityTagAAAGetTest(@Context Request req) {
        Date date = RequestTest.getYear1900();
        boolean ok = RequestTest.evaluatePreconditionsDateEntityTag(req, date, "AAA");
        return RequestTest.createResponse(ok);
    }

    @GET
    @Path(value="/preconditionsNowAAAGet")
    public Response evaluatePreconditionsDateEntityTagAAAGetTest(@Context Request req) {
        Date date = Calendar.getInstance().getTime();
        boolean ok = RequestTest.evaluatePreconditionsDateEntityTag(req, date, "AAA");
        return RequestTest.createResponse(ok);
    }

    @GET
    @Path(value="/preconditionsNowGet")
    public Response evaluatePreconditionsDateGetTest(@Context Request req) {
        Date date = Calendar.getInstance().getTime();
        boolean ok = RequestTest.evaluatePreconditionsDate(req, date);
        return RequestTest.createResponse(ok);
    }

    @GET
    @Path(value="/preconditionsAgesAgoGet")
    public Response evaluatePreconditionsAgesAgoGetTest(@Context Request req) {
        Date date = RequestTest.getYear1900();
        boolean ok = RequestTest.evaluatePreconditionsDate(req, date);
        return RequestTest.createResponse(ok);
    }

    @GET
    @Path(value="/preconditionsGet")
    public Response evaluatePreconditionsGetTest(@Context Request req) {
        boolean ok = RequestTest.evaluatePreconditions(req);
        return RequestTest.createResponse(ok);
    }

    @GET
    @Path(value="/preconditionsHead")
    public Response evaluatePreconditionsHeadTest(@Context Request req) {
        boolean ok = RequestTest.evaluatePreconditions(req);
        return RequestTest.createResponse(ok);
    }
}

