/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.responsebuilder;

import ee.jakarta.tck.ws.rs.api.rs.core.responseclient.JAXRSClientIT;
import ee.jakarta.tck.ws.rs.api.rs.core.responseclient.VerificationResult;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.SinglevaluedMap;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class BuilderClientIT
extends JAXRSClientIT {
    static final String URL = "http://localhost:888/noUrl";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Override
    @Test
    public void statusTest1() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        Response resp = null;
        Response.ResponseBuilder respb = null;
        for (int status : this.status_codes) {
            respb = Response.ok();
            respb = respb.status(status);
            resp = respb.build();
            result.append(this.verifyStatus(resp, status));
        }
        BuilderClientIT.logMsg(result);
        Assertions.assertTrue((boolean)result.pass);
    }

    @Override
    @Test
    public void statusTest2() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        Response resp = null;
        Response.ResponseBuilder respb = null;
        for (int i = 0; i < this.status_codes.length - 1; ++i) {
            respb = Response.ok();
            respb = respb.status(this.resp_status[i]);
            resp = respb.build();
            result.append(this.verifyStatus(resp, this.status_codes[i]));
        }
        BuilderClientIT.logMsg(result);
        Assertions.assertTrue((boolean)result.pass);
    }

    @Test
    public void expiresTest() throws JAXRSCommonClient.Fault {
        List expires;
        Date now = Calendar.getInstance().getTime();
        Response.ResponseBuilder rs = Response.ok();
        rs.expires(now);
        Response response = rs.build();
        MultivaluedMap metadata = response.getMetadata();
        if (metadata == null) {
            Assertions.fail((String)"No metadata in response");
        }
        if ((expires = (List)response.getMetadata().get((Object)"Expires")) == null || expires.isEmpty()) {
            Assertions.fail((String)"No Expires property in metadata");
        }
        boolean condition = false;
        Object fetched = expires.iterator().next();
        if (Date.class.isInstance(fetched)) {
            condition = ((Date)fetched).compareTo(now) == 0;
        } else if (String.class.isInstance(fetched)) {
            condition = BuilderClientIT.formats(now).contains(fetched.toString());
        } else {
            Assertions.fail((String)"Fetched object not recognised");
        }
        Assertions.assertTrue((boolean)condition, (String)("Expires value not matched, set: " + now.toString() + "fetched:" + fetched.toString()));
        BuilderClientIT.logMsg("Set and fetched expire dates matched");
    }

    @Test
    public void allowStringArrayTest() throws JAXRSCommonClient.Fault {
        String[] methods = new String[]{JAXRSCommonClient.Request.OPTIONS.name(), JAXRSCommonClient.Request.TRACE.name()};
        Response.ResponseBuilder rb = RuntimeDelegate.getInstance().createResponseBuilder();
        Response response = rb.allow(methods).build();
        Set set = response.getAllowedMethods();
        String responseMethods = JaxrsUtil.iterableToString(" ", set);
        for (String method : methods) {
            BuilderClientIT.assertContains(responseMethods, method, new Object[]{"Expected allow method", method, "was not found in response allowed methods", responseMethods});
            BuilderClientIT.logMsg("Found expected allowed method", method);
        }
    }

    @Test
    public void allowStringArrayTruncateDuplicatesTest() throws JAXRSCommonClient.Fault {
        String[] methods = new String[]{JAXRSCommonClient.Request.OPTIONS.name(), JAXRSCommonClient.Request.OPTIONS.name()};
        Response.ResponseBuilder rb = RuntimeDelegate.getInstance().createResponseBuilder();
        Response response = rb.allow(methods).build();
        Set set = response.getAllowedMethods();
        BuilderClientIT.assertEqualsInt(1, set.size(), "Only one allow method should be present");
        BuilderClientIT.assertEquals((String)set.iterator().next(), JAXRSCommonClient.Request.OPTIONS.name(), JAXRSCommonClient.Request.OPTIONS.name(), "has not been found in allowed methods");
        BuilderClientIT.logMsg(JAXRSCommonClient.Request.OPTIONS.name(), "has been found in allowed methods");
    }

    @Test
    public void allowStringArrayNullRemovesAllTest() throws JAXRSCommonClient.Fault {
        String[] methods = new String[]{JAXRSCommonClient.Request.OPTIONS.name(), JAXRSCommonClient.Request.GET.name()};
        Response.ResponseBuilder rb = RuntimeDelegate.getInstance().createResponseBuilder();
        Response response = rb.allow(methods).allow((String[])null).build();
        Set set = response.getAllowedMethods();
        BuilderClientIT.assertEqualsInt(0, set.size(), "No one allow method should be present");
        BuilderClientIT.logMsg("Allowed methods has been removed by null value as expected");
    }

    @Test
    public void allowStringSetTest() throws JAXRSCommonClient.Fault {
        TreeSet<String> methods = new TreeSet<String>();
        methods.add(JAXRSCommonClient.Request.OPTIONS.name());
        methods.add(JAXRSCommonClient.Request.TRACE.name());
        Response.ResponseBuilder rb = RuntimeDelegate.getInstance().createResponseBuilder();
        Response response = rb.allow(methods).build();
        Set set = response.getAllowedMethods();
        String responseMethods = JaxrsUtil.iterableToString(" ", set);
        for (String method : methods) {
            BuilderClientIT.assertContains(responseMethods, method, new Object[]{"Expected allow method", method, "was not found in response allowed methods", responseMethods});
            BuilderClientIT.logMsg("Found expected allowed method", method);
        }
    }

    @Test
    public void allowStringSetNullRemovesAllTest() throws JAXRSCommonClient.Fault {
        TreeSet<String> methods = new TreeSet<String>();
        methods.add(JAXRSCommonClient.Request.OPTIONS.name());
        methods.add(JAXRSCommonClient.Request.TRACE.name());
        Response.ResponseBuilder rb = RuntimeDelegate.getInstance().createResponseBuilder();
        Response response = rb.allow(methods).allow((Set)null).build();
        Set set = response.getAllowedMethods();
        BuilderClientIT.assertEqualsInt(0, set.size(), "No one allow method should be present");
        BuilderClientIT.logMsg("Allowed methods has been removed by null value as expected");
    }

    @Test
    public void encodingTest() throws JAXRSCommonClient.Fault {
        String[] encodings = new String[]{"gzip", "ccitt", "pic"};
        VerificationResult vr = new VerificationResult();
        for (String encoding : encodings) {
            Response response = Response.ok().encoding(encoding).build();
            vr.append(this.verifyEncoding(response, Collections.singletonList(encoding)));
        }
        BuilderClientIT.logMsg(vr.message);
        Assertions.assertTrue((boolean)vr.pass);
        BuilderClientIT.logMsg("Found expected encodings");
    }

    @Test
    public void linkUriStringTest() throws JAXRSCommonClient.Fault {
        URI uri = null;
        try {
            uri = new URI(URL);
        }
        catch (URISyntaxException e) {
            Assertions.fail((String)e.getMessage());
        }
        String rel = "REL";
        Response response = Response.ok().link(uri, rel).build();
        Link link = response.getLink(rel);
        Assertions.assertTrue((link != null ? 1 : 0) != 0, (String)"link is null");
        Assertions.assertTrue((boolean)link.toString().contains(URL), (String)("link" + link + "does not contain expectedhttp://localhost:888/noUrl"));
        BuilderClientIT.logMsg("Found expected link", link);
    }

    @Test
    public void linkStringStringTest() throws JAXRSCommonClient.Fault {
        String rel = "REL";
        Response response = Response.ok().link(URL, rel).build();
        Link link = response.getLink(rel);
        Assertions.assertTrue((link != null ? 1 : 0) != 0, (String)"link is null");
        Assertions.assertTrue((boolean)link.toString().contains(URL), (String)("link" + link + "does not contain expectedhttp://localhost:888/noUrl"));
        BuilderClientIT.logMsg("Found expected link", link);
    }

    @Test
    public void linksTest() throws JAXRSCommonClient.Fault {
        String rel = "REL";
        Link link1 = Link.fromUri((String)URL).rel(rel + "1").build(new Object[0]);
        Link link11 = Link.fromUri((String)URL).rel(rel + "11").build(new Object[0]);
        Link link2 = Link.fromUri((String)"http://localhost:888/noUrl/link2").rel(rel + "2").build(new Object[0]);
        Response response = Response.ok().links(new Link[]{link1, link11, link2}).build();
        Link link = response.getLink(rel + "1");
        Assertions.assertTrue((link != null ? 1 : 0) != 0, (String)"link is null");
        Assertions.assertTrue((boolean)link.toString().contains(URL), (String)("link" + link + "does not contain expectedhttp://localhost:888/noUrl"));
        link = response.getLink(rel + "11");
        Assertions.assertTrue((link != null ? 1 : 0) != 0, (String)"link is null");
        Assertions.assertTrue((boolean)link.toString().contains(URL), (String)("link" + link + "does not contain expectedhttp://localhost:888/noUrl"));
        link = response.getLink(rel + "2");
        Assertions.assertTrue((link != null ? 1 : 0) != 0, (String)"link is null");
        Assertions.assertTrue((boolean)link.toString().contains("http://localhost:888/noUrl/link2"), (String)("link" + link + "does not contain expectedhttp://localhost:888/noUrl/link2"));
        BuilderClientIT.logMsg("Found expected links");
    }

    @Test
    public void replaceAllTest() throws JAXRSCommonClient.Fault {
        String[] headers = new String[]{"header1", "header2", "header3"};
        String header99 = "header99";
        SinglevaluedMap mv = new SinglevaluedMap();
        mv.add(header99, header99);
        Response response = Response.ok().header(headers[0], (Object)headers[0]).header(headers[1], (Object)headers[1]).header(headers[2], (Object)headers[2]).replaceAll(mv).build();
        for (String header : headers) {
            Assertions.assertTrue((response.getHeaderString(header) == null ? 1 : 0) != 0, (String)("response contains non replaced header" + header));
        }
        Assertions.assertTrue((boolean)response.getHeaderString(header99).equals(header99), (String)("response does not contain header from replacedAll map" + header99));
    }

    @Test
    public void replaceAllByNullTest() throws JAXRSCommonClient.Fault {
        String[] headers = new String[]{"header1", "header2", "header3"};
        Response response = Response.ok().header(headers[0], (Object)headers[0]).header(headers[1], (Object)headers[1]).header(headers[2], (Object)headers[2]).replaceAll(null).build();
        for (String header : headers) {
            Assertions.assertTrue((response.getHeaderString(header) == null ? 1 : 0) != 0, (String)("response contains non replaced header" + header));
        }
    }

    @Override
    @Test
    public void variantsTest() throws JAXRSCommonClient.Fault {
        List<String> encoding = Arrays.asList("gzip", "compress");
        List<String> vars = Arrays.asList("Accept-Language", "Accept-Encoding");
        MediaType mt = MediaType.APPLICATION_JSON_TYPE;
        Response.ResponseBuilder rb = Response.ok();
        rb = rb.variants(BuilderClientIT.getVariantList(encoding, mt).toArray(new Variant[0]));
        Response response = rb.build();
        VerificationResult result = new VerificationResult();
        result.append(this.verifyVary(response, vars));
        BuilderClientIT.logMsg(result.message);
        Assertions.assertTrue((boolean)result.pass);
    }

    private static String formats(Date date) {
        TestUtil.logMsg("Creating possible string format list");
        StringBuilder sb = new StringBuilder();
        for (String tz : TimeZone.getAvailableIDs()) {
            DateFormat format = JaxrsUtil.createDateFormat(TimeZone.getTimeZone(tz));
            sb.append(format.format(date));
        }
        return sb.toString();
    }

    protected Invocation.Builder invocation() {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(URL);
        Invocation.Builder b = target.request();
        return b;
    }
}

