/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.runtime;

import jakarta.el.FunctionMapper;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import org.glassfish.wasp.security.SecurityUtil;

public final class ProtectedFunctionMapper
extends FunctionMapper {
    private HashMap<String, Method> fnmap = null;
    private Method theMethod = null;

    private ProtectedFunctionMapper() {
    }

    public static ProtectedFunctionMapper getInstance() {
        ProtectedFunctionMapper funcMapper = SecurityUtil.isPackageProtectionEnabled() ? AccessController.doPrivileged(ProtectedFunctionMapper::new) : new ProtectedFunctionMapper();
        funcMapper.fnmap = new HashMap();
        return funcMapper;
    }

    public void mapFunction(String fnQName, Class<?> c, String methodName, Class<?>[] args) {
        Method method;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                method = AccessController.doPrivileged(() -> c.getDeclaredMethod(methodName, args));
            }
            catch (PrivilegedActionException ex) {
                throw new RuntimeException("Invalid function mapping - no such method: " + ex.getException().getMessage());
            }
        }
        try {
            method = c.getDeclaredMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Invalid function mapping - no such method: " + e.getMessage());
        }
        this.fnmap.put(fnQName, method);
    }

    public static ProtectedFunctionMapper getMapForFunction(String fnQName, Class<?> c, String methodName, Class<?>[] args) {
        Method method;
        ProtectedFunctionMapper funcMapper;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            funcMapper = AccessController.doPrivileged(ProtectedFunctionMapper::new);
            try {
                method = AccessController.doPrivileged(() -> c.getDeclaredMethod(methodName, args));
            }
            catch (PrivilegedActionException ex) {
                throw new RuntimeException("Invalid function mapping - no such method: " + ex.getException().getMessage());
            }
        }
        funcMapper = new ProtectedFunctionMapper();
        try {
            method = c.getDeclaredMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Invalid function mapping - no such method: " + e.getMessage());
        }
        funcMapper.theMethod = method;
        return funcMapper;
    }

    public Method resolveFunction(String prefix, String localName) {
        if (this.fnmap != null) {
            return this.fnmap.get(prefix + ":" + localName);
        }
        return this.theMethod;
    }
}

