/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.parser;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;

public final class ParsedLogRecord
implements Serializable {
    private static final long serialVersionUID = -5509051668657749139L;
    private final String formattedLogRecord;
    private LocalDate date;
    private LocalTime time;
    private ZoneOffset timezone;
    private String level;
    private String productId;
    private String loggerName;
    private Long threadId;
    private String threadName;
    private Integer levelValue;
    private String message;
    private String messageKey;
    private final Map<String, String> supplementalAttributes = new HashMap<String, String>(0);

    public ParsedLogRecord(String formattedContent) {
        this.formattedLogRecord = formattedContent;
    }

    public String getFormattedLogRecord() {
        return this.formattedLogRecord;
    }

    public OffsetDateTime getTimestamp() {
        if (this.date == null || this.time == null) {
            return null;
        }
        return OffsetDateTime.of(this.date, this.time, this.timezone);
    }

    public LocalTime getTime() {
        return this.time;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.date = timestamp.toLocalDate();
        this.time = timestamp.toLocalTime();
        this.timezone = timestamp.getOffset();
    }

    public void setTime(LocalTime time) {
        this.time = time;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLogLevel(String level) {
        this.level = level;
    }

    public Integer getLevelValue() {
        return this.levelValue;
    }

    public void setLogLevelValue(Integer level) {
        this.levelValue = level;
    }

    public String getLogger() {
        return this.loggerName;
    }

    public void setLogger(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public Long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(Long threadId) {
        this.threadId = threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public Map<String, String> getSupplementalAttributes() {
        return this.supplementalAttributes;
    }

    public void setSupplementalValue(String key, String value) {
        this.supplementalAttributes.put(key, value);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Log record: <").append(this.formattedLogRecord).append('>').append(System.lineSeparator());
        return buffer.toString();
    }
}

