/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spi.client.deployment;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public final class Validate {
    private static Map<Class<? extends Archive<?>>, String> archiveExpressions = new HashMap();

    private Validate() {
    }

    public static String getArchiveExpression(Class<? extends Archive<?>> type) {
        return archiveExpressions.get(type);
    }

    public static boolean archiveHasExpectedFileExtension(Archive<?> archive) {
        String name = archive.getName();
        for (Map.Entry<Class<Archive<?>>, String> entry : archiveExpressions.entrySet()) {
            if (name.endsWith(entry.getValue()) || !entry.getKey().isInstance(archive)) continue;
            return false;
        }
        return true;
    }

    public static boolean isArchiveOfType(Class<? extends Archive<?>> type, Archive<?> archive) {
        String expression = Validate.getArchiveExpression(type);
        if (expression == null) {
            return false;
        }
        return archive.getName().endsWith(expression);
    }

    public static void notNull(Object obj, String message) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrEmpty(String string, String message) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void stateNotNull(Object obj, String message) throws IllegalStateException {
        if (obj == null) {
            throw new IllegalStateException(message);
        }
    }

    public static void configurationDirectoryExists(String string, String message) throws ConfigurationException {
        if (string == null || string.length() == 0 || !new File(string).isDirectory()) {
            throw new ConfigurationException(message);
        }
    }

    static {
        archiveExpressions.put(JavaArchive.class, ".jar");
        archiveExpressions.put(WebArchive.class, ".war");
        archiveExpressions.put(EnterpriseArchive.class, ".ear");
        archiveExpressions.put(ResourceAdapterArchive.class, ".rar");
    }
}

