/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.signature.ui.contentassist;

import java.net.URL;
import org.eclipse.comma.signature.ui.contentassist.AbstractInterfaceSignatureProposalProvider;
import org.eclipse.comma.signature.ui.contentassist.HtmlConfigurableCompletionProposal;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class InterfaceSignatureProposalProvider
extends AbstractInterfaceSignatureProposalProvider {
    private final Image templateIcon = ImageDescriptor.createFromURL((URL)Platform.getBundle((String)"org.eclipse.comma.icons").getResource("icons/template.png")).createImage();
    private final int TEMPLATE_DEFAULT_PRIORITY = 600;
    public static String INTERFACE_TITLE = "Interface signature definition";
    private static String INTERFACE_INFO = "An interface signature defines commands, signals and notifications. Optionally, types may be defined.";
    public static String ENUM_TITLE = "Enum definition";
    private static String ENUM_INFO = "Enum types define a set of enum literals as possible values";
    public static String RECORD_TITLE = "Record definition";
    private static String RECORD_INFO = "Record types define tuples of typed fields";
    public static String TYPE_TITLE = "Type definition";
    private static String TYPE_INFO = "Simple type";
    public static String VECTOR_TITLE = "Vector definition";
    private static String VECTOR_INFO = "Simple Vector with elements of type Integer";
    public static String NOTIFICATION_TITLE = "Notification";
    private static String NOTIFICATION_INFO = "Simple notification";
    public static String SIGNAL_TITLE = "Signal";
    private static String SIGNAL_INFO = "Simple signal";
    public static String COMMAND_TITLE = "Command";
    private static String COMMAND_INFO = "Simple Command";
    public static String COMMAND_IN_TITLE = "Command in";
    private static String COMMAND_IN_INFO = "Simple Command with in parameter";
    public static String COMMAND_OUT_TITLE = "Command out";
    private static String COMMAND_OUT_INFO = "Simple Command with out parameter";
    public static String COMMAND_INOUT_TITLE = "Command inout";
    private static String COMMAND_INOUT_INFO = "Simple Command with inout parameter";

    private HtmlConfigurableCompletionProposal createTemplate(String name, String content, String additionalInfo, Integer nrIndents, ContentAssistContext context) {
        return this.createTemplate(name, content, additionalInfo, nrIndents, context, 600);
    }

    private HtmlConfigurableCompletionProposal createTemplate(String name, String content, String additionalInfo, Integer nrIndents, ContentAssistContext context, int priority) {
        String _plus_2;
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        String indent = "";
        int i = 0;
        while (i < nrIndents) {
            String _indent = indent;
            indent = String.valueOf(_indent) + "\t";
            ++i;
        }
        String _lineSeparator = System.lineSeparator();
        String _lineSeparator_1 = System.lineSeparator();
        String _plus = String.valueOf(_lineSeparator_1) + indent;
        String indentedContent = content.replace(_lineSeparator, _plus);
        String _lineSeparator_2 = System.lineSeparator();
        String _plus_1 = String.valueOf(_lineSeparator_2) + indent;
        indentedContent = _plus_2 = String.valueOf(_plus_1) + indentedContent;
        String finalAdditionalInfo = content;
        StyledString _styledString = new StyledString(name);
        HtmlConfigurableCompletionProposal proposal = this.createHtmlCompletionProposal(indentedContent, _styledString, this.templateIcon, 600, context);
        if (proposal instanceof ConfigurableCompletionProposal) {
            while (finalAdditionalInfo.startsWith(System.lineSeparator()) || finalAdditionalInfo.startsWith("\r")) {
                finalAdditionalInfo = finalAdditionalInfo.substring(1);
            }
            finalAdditionalInfo = "<html><body bgcolor=\"#FFFFE1\"><style> body { font-size:9pt; font-family:'Segoe UI' }</style><pre>" + finalAdditionalInfo + "</pre>";
            if (additionalInfo != null) {
                finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "<p>" + additionalInfo + "</p>";
            }
            finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "</body></html>";
            proposal.setAdditionalProposalInfo(finalAdditionalInfo);
            proposal.setProposalContextResource((Resource)context.getResource());
            proposal.setPriority(priority);
        }
        _xblockexpression = proposal;
        return _xblockexpression;
    }

    private HtmlConfigurableCompletionProposal createHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        return this.doCreateHtmlCompletionProposal(proposal, displayString, image, priority, context);
    }

    private HtmlConfigurableCompletionProposal doCreateHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        int replacementOffset = context.getReplaceRegion().getOffset();
        int replacementLength = context.getReplaceRegion().getLength();
        int _length = proposal.length();
        HtmlConfigurableCompletionProposal result = new HtmlConfigurableCompletionProposal(proposal, replacementOffset, replacementLength, _length, image, displayString, null, null);
        result.setPriority(priority);
        result.setMatcher(context.getMatcher());
        result.setReplaceContextLength(context.getReplaceContextLength());
        _xblockexpression = result;
        return _xblockexpression;
    }

    @Override
    public void complete_Signature(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_Signature(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("signature Iinterface");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("commands");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int CommandIn (in int x)");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("signals");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Signal(int x)");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("notifications");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Notification(int x)");
        _builder.newLine();
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(INTERFACE_TITLE, proposal, INTERFACE_INFO, 0, context));
    }

    public void complete_EnumTypeDecl(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_EnumTypeDecl(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("enum Enum {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("First");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(ENUM_TITLE, proposal, ENUM_INFO, 1, context));
    }

    public void complete_TypeDecl(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_TypeDecl(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("type newType");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(TYPE_TITLE, proposal, TYPE_INFO, 1, context));
    }

    public void complete_RecordTypeDecl(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_RecordTypeDecl(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("record Record {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int key, ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int value");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(RECORD_TITLE, proposal, RECORD_INFO, 1, context));
    }

    @Override
    public void complete_Command(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_Command(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("int Command");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(COMMAND_TITLE, proposal, COMMAND_INFO, 1, context));
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("int CommandIn (in int value)");
        String proposalIn = _builder_1.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(COMMAND_IN_TITLE, proposalIn, COMMAND_IN_INFO, 1, context));
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("int CommandOut (out int value)");
        String proposalOut = _builder_2.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(COMMAND_OUT_TITLE, proposalOut, COMMAND_OUT_INFO, 1, context));
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("int CommandInOut (inout int value)");
        String proposalInout = _builder_3.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(COMMAND_INOUT_TITLE, proposalInout, COMMAND_INOUT_INFO, 1, context));
    }

    @Override
    public void complete_Notification(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_Notification(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Notification(int x)");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(NOTIFICATION_TITLE, proposal, NOTIFICATION_INFO, 1, context));
    }

    public void complete_VectorTypeDecl(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_VectorTypeDecl(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("vector Vector = int[][]");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(VECTOR_TITLE, proposal, VECTOR_INFO, 1, context));
    }

    @Override
    public void complete_Signal(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_Signal(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Signal(int x)");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(SIGNAL_TITLE, proposal, SIGNAL_INFO, 1, context));
    }
}

