/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableByteStackFactory;
import org.eclipse.collections.api.stack.primitive.ImmutableByteStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableByteArrayStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableByteEmptyStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableByteSingletonStack;

public class ImmutableByteStackFactoryImpl
implements ImmutableByteStackFactory {
    public ImmutableByteStack empty() {
        return ImmutableByteEmptyStack.INSTANCE;
    }

    public ImmutableByteStack of() {
        return this.empty();
    }

    public ImmutableByteStack with() {
        return this.empty();
    }

    public ImmutableByteStack of(byte one) {
        return this.with(one);
    }

    public ImmutableByteStack with(byte one) {
        return new ImmutableByteSingletonStack(one);
    }

    public ImmutableByteStack of(byte ... items) {
        return this.with(items);
    }

    public ImmutableByteStack with(byte ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableByteArrayStack.newStackWith(items);
    }

    public ImmutableByteStack ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    public ImmutableByteStack withAll(ByteIterable items) {
        if (items instanceof ImmutableByteStack) {
            return (ImmutableByteStack)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableByteStack ofAllReversed(ByteIterable items) {
        return this.withAllReversed(items);
    }

    public ImmutableByteStack withAllReversed(ByteIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableByteArrayStack.newStackFromTopToBottom(items);
    }
}

