/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.extension.genchain.patterns;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.model.pattern.Node;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.pattern.execution.InternalPatternContext;
import org.eclipse.egf.pattern.execution.OutputManager;
import org.eclipse.egf.portfolio.genchain.generationChain.EmfGeneration;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.importer.ecore.EcoreImporter;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.polarsys.capella.extension.genchain.capellaextension.CapellaEmfGeneration;
import org.polarsys.kitalpha.emde.genchain.utils.EmdeEcoreImporterHelper;
import org.polarsys.kitalpha.emde.genchain.utils.GenRuntimeVersionHelper;
import org.polarsys.kitalpha.emde.genchain.utils.GenmodelLocator;

public class CapellaGenmodelPattern {
    protected CapellaEmfGeneration parameter;
    protected EcoreImporter importer;

    public void generate(Object argument) throws Exception {
        InternalPatternContext ctx = (InternalPatternContext)argument;
        Node.Container currentNode = ctx.getNode();
        List parameterList = null;
        for (Object parameterParameter : parameterList) {
            this.parameter = (CapellaEmfGeneration)parameterParameter;
            if (!this.preCondition((PatternContext)ctx)) continue;
            ctx.setNode(new Node.Container(currentNode, this.getClass()));
            this.orchestration((PatternContext)argument);
        }
        if (ctx.useReporter()) {
            ctx.getReporter().executionFinished(OutputManager.computeExecutionOutput((PatternContext)ctx), (PatternContext)ctx);
        }
    }

    public String orchestration(PatternContext ctx) throws Exception {
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        Node.Container currentNode = ictx.getNode();
        this.method_create(new StringBuffer(), (PatternContext)ictx);
        this.method_updateContent(new StringBuffer(), (PatternContext)ictx);
        this.method_save(new StringBuffer(), (PatternContext)ictx);
        ictx.setNode(currentNode);
        if (ictx.useReporter()) {
            HashMap<String, CapellaEmfGeneration> parameterValues = new HashMap<String, CapellaEmfGeneration>();
            parameterValues.put("parameter", this.parameter);
            String outputWithCallBack = OutputManager.computeLoopOutput((PatternContext)ictx);
            String loop = OutputManager.computeLoopOutputWithoutCallback((PatternContext)ictx);
            ictx.getReporter().loopFinished(loop, outputWithCallBack, (PatternContext)ictx, parameterValues);
        }
        return null;
    }

    protected void method_create(StringBuffer out, PatternContext ctx) throws Exception {
        Path ecorePath = new Path(this.parameter.getModelPath());
        IFile file = GenmodelLocator.lookup((IPath)ecorePath);
        if (file == null) {
            TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
            IPath genmodelPath = ecorePath.removeFileExtension().addFileExtension("genmodel");
            genmodelPath = new Path(this.parameter.getPluginName()).append(genmodelPath.removeFirstSegments(1));
            URI genmodelURI = URI.createPlatformPluginURI((String)genmodelPath.toString(), (boolean)false);
            try {
                resourceSet.getResource(genmodelURI, true);
            }
            catch (Exception exception) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.parameter.getPluginName());
                if (!project.exists()) {
                    project.create(null);
                }
                if (!project.isOpen()) {
                    project.open(null);
                }
                URI ecoreURI = URI.createPlatformResourceURI((String)ecorePath.toString(), (boolean)false);
                this.importer = EmdeEcoreImporterHelper.createEcoreImporter((IPath)genmodelPath.removeLastSegments(1), (URI)ecoreURI, (EmfGeneration)this.parameter);
            }
            genmodelURI = URI.createPlatformResourceURI((String)genmodelPath.toString(), (boolean)false);
            ((HashMap)ctx.getValue("genmodel.uris")).put(this.parameter.getModelPath(), genmodelURI);
        } else {
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
            ((HashMap)ctx.getValue("genmodel.uris")).put(this.parameter.getModelPath(), uri);
        }
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "create", out.toString());
    }

    protected void method_save(StringBuffer out, PatternContext ctx) throws Exception {
        if (this.importer != null) {
            this.importer.saveGenModelAndEPackages((Monitor)new BasicMonitor());
        }
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "save", out.toString());
    }

    protected void method_updateContent(StringBuffer out, PatternContext ctx) throws Exception {
        if (this.importer == null) {
            return;
        }
        GenModel genModel = this.importer.getGenModel();
        String emfModelPath = this.parameter.getModelPath();
        for (GenPackage genPackage : genModel.getGenPackages()) {
            String ecoreFileName = genPackage.getEcorePackage().eResource().getURI().lastSegment();
            if (emfModelPath.contains(ecoreFileName)) {
                genPackage.setBasePackage(this.parameter.getBasePackage());
            }
            genPackage.setResource(GenResourceKind.XMI_LITERAL);
            genPackage.setDisposableProviderFactory(true);
            genPackage.setGenerateExampleClass(false);
            genPackage.setMultipleEditorPages(false);
            genPackage.setExtensibleProviderFactory(true);
            genPackage.setChildCreationExtenders(true);
        }
        String emfPluginName = this.parameter.getPluginName();
        genModel.setModelPluginID(emfPluginName);
        genModel.setModelDirectory("/" + emfPluginName + "/src");
        genModel.setNonNLSMarkers(true);
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.codegen");
        genModel.setRuntimeVersion(GenRuntimeVersionHelper.getVersion((Version)bundle.getVersion()));
        genModel.setRootExtendsClass("org.eclipse.emf.ecore.impl.EObjectImpl");
        genModel.setCodeFormatting(true);
        genModel.setOptimizedHasChildren(true);
        genModel.setTableProviders(false);
        genModel.setColorProviders(false);
        genModel.setOperationReflection(false);
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "updateContent", out.toString());
    }

    public boolean preCondition(PatternContext ctx) throws Exception {
        return true;
    }

    public void set_parameter(CapellaEmfGeneration parameter) {
        this.parameter = parameter;
    }

    public void set_importer(EcoreImporter importer) {
        this.importer = importer;
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("parameter", this.parameter);
        return parameters;
    }
}

