/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.activities;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridge;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.interactive.util.ResourceUtil;
import org.eclipse.emf.diffmerge.bridge.traces.gen.bridgetraces.BridgetracesFactory;
import org.eclipse.emf.diffmerge.bridge.traces.gen.bridgetraces.Trace;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.impl.scopes.FragmentedModelScope;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.ReqIFMapping;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.RequirementsVPBridge;
import org.polarsys.capella.vp.requirements.importer.transposer.policies.ReqIFImporterDiffPolicy;
import org.polarsys.capella.vp.requirements.importer.transposer.policies.ReqIFMergePolicy;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class TransposerTransformation
extends AbstractActivity {
    public static String getId() {
        return TransposerTransformation.class.getCanonicalName();
    }

    protected IStatus _run(ActivityParameters activityParams) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        IEditableModelScope sourceScope = (IEditableModelScope)context.get((Object)"SOURCE_SCOPE");
        final IEditableModelScope targetScope = (IEditableModelScope)context.get((Object)"TARGET_SCOPE");
        ReqIFMapping mapping = new ReqIFMapping(context);
        RequirementsVPBridge bridge = this.createBridge(targetScope, (IBridge<IEditableModelScope, IEditableModelScope>)mapping);
        Resource traceResource = this.getCreateResource(this.getTraceURI(this.getTransformationURI(targetScope)), this.getTransformationDomain(targetScope));
        IBridgeTrace existingTrace = this.getTrace(bridge, traceResource);
        IIncrementalBridgeExecution execution2 = bridge.executeOn(sourceScope, targetScope, null, existingTrace, true, (IProgressMonitor)new NullProgressMonitor());
        bridge.mergeInteractively(execution2, (IProgressMonitor)new NullProgressMonitor());
        this.save(execution2, traceResource, execution2.getTrace(), targetScope);
        TransactionHelper.getExecutionManager((Resource)traceResource).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                HoldingResourceHelper.flushHoldingResource((TransactionalEditingDomain)TransactionHelper.getEditingDomain((EObject)((EObject)targetScope.getContents().get(0))));
            }
        });
        return Status.OK_STATUS;
    }

    protected RequirementsVPBridge createBridge(IEditableModelScope targetScope, IBridge<IEditableModelScope, IEditableModelScope> bridge) {
        return new RequirementsVPBridge(targetScope, bridge, (IDiffPolicy)new ReqIFImporterDiffPolicy(), (IMergePolicy)new ReqIFMergePolicy(), null){

            @Override
            protected EMFDiffNode createDiffNode(EComparison comparison, EditingDomain domain) {
                EMFDiffNode diffNode = super.createDiffNode(comparison, domain);
                return diffNode;
            }
        };
    }

    private void save(IIncrementalBridgeExecution execution, Resource traceResource, IBridgeTrace trace, IEditableModelScope targetScope) {
        try {
            traceResource.save(new HashMap());
            ((EObject)targetScope.getContents().get(0)).eResource().save(new HashMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void compact(Resource resource) {
        List filtered = EcoreUtil.filterDescendants((Collection)resource.getContents());
        resource.getContents().retainAll((Collection)filtered);
    }

    protected static void setTrace(final Resource traceResource, final IBridgeTrace trace) {
        TransactionHelper.getExecutionManager((Resource)traceResource).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                traceResource.getContents().clear();
                traceResource.getContents().add((Object)((EObject)trace));
            }
        });
    }

    protected TransactionalEditingDomain getTransformationDomain(IEditableModelScope definition) {
        return TransactionUtil.getEditingDomain((ResourceSet)((Resource)((FragmentedModelScope)definition).getRootResources().iterator().next()).getResourceSet());
    }

    protected URI getTransformationURI(IEditableModelScope definition) {
        return ((Resource)((FragmentedModelScope)definition).getRootResources().iterator().next()).getURI();
    }

    protected URI getTraceURI(URI uri) {
        return uri.appendFileExtension("bridgetraces");
    }

    protected IBridgeTrace getTrace(final RequirementsVPBridge bridge, final Resource traceResource) {
        EObject root;
        Trace trace = null;
        if (!traceResource.getContents().isEmpty() && (root = (EObject)traceResource.getAllContents().next()) instanceof IBridgeTrace) {
            trace = (IBridgeTrace)root;
        }
        if (trace == null) {
            trace = BridgetracesFactory.eINSTANCE.createTrace();
        }
        final Trace trace2 = trace;
        TransactionHelper.getExecutionManager((Resource)traceResource).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                if (traceResource.getContents().isEmpty()) {
                    traceResource.getContents().add((Object)trace2);
                }
                bridge.initializeTrace(trace2);
            }
        });
        return trace;
    }

    protected Resource getCreateResource(URI uri, TransactionalEditingDomain domain) {
        ResourceSet rs = domain.getResourceSet();
        Resource result = ResourceUtil.getCreateResourceForUri((URI)uri, (ResourceSet)rs);
        ResourceUtil.ensureLoaded((Resource)result);
        return result;
    }
}

