/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.junit.Assert;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.kitalpha.vp.requirements.Requirements.IdentifiableElement;

public class InsertRemoveRequirementTool
extends InsertRemoveTool {
    protected DiagramContext context;
    protected Collection<DDiagramElement> elementsBeforeApplyingTool;
    protected DDiagramElement newElement;

    public InsertRemoveRequirementTool(DiagramContext context, String toolName) {
        super(context, toolName);
        this.context = context;
    }

    public InsertRemoveRequirementTool(DiagramContext context, String toolName, String containerId) {
        super(context, toolName, containerId);
        this.context = context;
    }

    private Collection<DDiagramElement> getDiagramOwnedElements() {
        return this.context.getDiagram().getOwnedDiagramElements();
    }

    protected void preRunTest() {
        super.preRunTest();
        this.elementsBeforeApplyingTool = new ArrayList<DDiagramElement>(this.getDiagramOwnedElements());
    }

    protected void postRunTest() {
        super.postRunTest();
        Collection newElements = this.getDiagramOwnedElements().stream().filter(e -> !this.elementsBeforeApplyingTool.contains(e)).collect(Collectors.toList());
        HashMap<String, DDiagramElement> idToNewElement = new HashMap<String, DDiagramElement>();
        for (DDiagramElement diagramElement : newElements) {
            ModelElement element;
            EObject target = diagramElement.getTarget();
            if (target instanceof ModelElement) {
                element = (ModelElement)target;
                idToNewElement.put(element.getId(), diagramElement);
                continue;
            }
            if (!(target instanceof IdentifiableElement)) continue;
            element = (IdentifiableElement)target;
            idToNewElement.put(element.getId(), diagramElement);
        }
        int i = 0;
        while (i < this.toInsert.length) {
            String id = this.toInsert[i];
            if (idToNewElement.containsKey(id)) {
                DDiagramElement diagramElement = (DDiagramElement)idToNewElement.get(id);
                this.getExecutionContext().putSemanticElement(id, diagramElement.getTarget());
            } else {
                Assert.fail((String)"The id of this element is not an id given in parameters.");
            }
            ++i;
        }
    }
}

