/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.vp.requirements.ju.transposer.TestRequirementsImportLauncher;

public class ImportTestCase
extends BasicTestCase {
    private static final String systemAnalysis = "24658239-7734-4c39-9402-83325c52d04c";
    private static final String inputFileName = "model/inputs/model1.reqif";
    private static final String projectTestName = "emptymodel";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(projectTestName);
    }

    public void test() throws Exception {
        SessionContext session = new SessionContext(this.getSession(projectTestName));
        final EObject target = session.getSemanticElement(systemAnalysis);
        if (target instanceof BlockArchitecture) {
            TransactionHelper.getExecutionManager((EObject)target).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    File file = IResourceHelpers.getFileOrFolderInTestPlugin(((Object)((Object)this)).getClass(), (String)ImportTestCase.inputFileName);
                    URI model = URI.createFileURI((String)file.getPath());
                    new TestRequirementsImportLauncher().launch(model, (BlockArchitecture)target, (IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
    }
}

