/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import java.util.List;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedStepsPathMatcher
implements PathMatcher {
    private final List<PatternStep> steps;
    private final PathMatcher next;
    private final int minSegments;
    private final int maxSegments;

    public FixedStepsPathMatcher(List<PatternStep> steps, PathMatcher next) {
        this.steps = steps;
        this.next = next;
        this.minSegments = steps.size() + next.getMinSegments();
        this.maxSegments = next.getMaxSegments() == Integer.MAX_VALUE ? Integer.MAX_VALUE : next.getMaxSegments() + steps.size();
    }

    @Override
    public int getMinSegments() {
        return this.minSegments;
    }

    @Override
    public int getMaxSegments() {
        return this.maxSegments;
    }

    @Override
    public boolean matches(String[] segments, int startIndex) {
        int remaining = segments.length - startIndex;
        if (remaining < this.minSegments || remaining > this.maxSegments) {
            return false;
        }
        int pos = startIndex;
        int i = 0;
        while (i < this.steps.size()) {
            PatternStep step = this.steps.get(i);
            if (!step.matches(segments[pos])) {
                return false;
            }
            ++i;
            ++pos;
        }
        return this.next.matches(segments, pos);
    }

    @Override
    public boolean isPrefix(String[] segments, int startIndex) {
        int pos = startIndex;
        for (int i = 0; pos < segments.length && i < this.steps.size(); ++i, ++pos) {
            PatternStep step = this.steps.get(i);
            if (step.matches(segments[pos])) continue;
            return false;
        }
        if (pos == segments.length) {
            return true;
        }
        return this.next.isPrefix(segments, pos);
    }
}

