/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.events.problems.internal;

import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.CacheLoader;
import org.gradle.internal.impldep.com.google.common.cache.LoadingCache;
import org.gradle.tooling.events.problems.Severity;

public class DefaultSeverity
implements Severity {
    private final int severity;
    private final boolean known;
    private static final LoadingCache<Integer, Severity> UNKNOWN_ENTRIES = CacheBuilder.newBuilder().build(new CacheLoader<Integer, Severity>(){

        @Override
        public Severity load(Integer key) {
            return new DefaultSeverity(key, false);
        }
    });

    public DefaultSeverity(int severity, boolean known) {
        this.severity = severity;
        this.known = known;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public boolean isKnown() {
        return this.known;
    }

    public static Severity from(int severity) {
        if (severity == Severity.ADVICE.getSeverity()) {
            return Severity.ADVICE;
        }
        if (severity == Severity.WARNING.getSeverity()) {
            return Severity.WARNING;
        }
        if (severity == Severity.ERROR.getSeverity()) {
            return Severity.ERROR;
        }
        return UNKNOWN_ENTRIES.getUnchecked(severity);
    }
}

