/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.ui.internal.view.task.BuildNode;
import org.eclipse.buildship.ui.internal.view.task.BuildTreeNode;
import org.eclipse.buildship.ui.internal.view.task.FaultyBuildTreeNode;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class TaskViewContent {
    private final List<BuildNode> allBuilds;
    private final List<FaultyBuildTreeNode> fauiltyBuilds;

    private TaskViewContent(List<BuildNode> allBuilds, List<FaultyBuildTreeNode> faultyBuilds) {
        this.allBuilds = allBuilds;
        this.fauiltyBuilds = faultyBuilds;
    }

    public List<FaultyBuildTreeNode> getFaultyBuilds() {
        return this.fauiltyBuilds;
    }

    public boolean isEmpty() {
        return this.allBuilds.isEmpty() && this.fauiltyBuilds.isEmpty();
    }

    public Collection<BuildNode> getBuilds() {
        return this.allBuilds;
    }

    public static TaskViewContent from(Map<File, Map<String, EclipseProject>> allModels, Map<File, BuildEnvironment> environments, List<InternalGradleBuild> faultyBuilds) {
        ArrayList<BuildNode> builds = new ArrayList<BuildNode>();
        for (Map.Entry<File, Map<String, EclipseProject>> model : allModels.entrySet()) {
            File rootProjectDir = model.getKey();
            BuildEnvironment buildEnvironment = environments.get(rootProjectDir);
            BuildTreeNode buildTreeNode = new BuildTreeNode(rootProjectDir, buildEnvironment);
            for (Map.Entry<String, EclipseProject> entry : model.getValue().entrySet()) {
                String includedBuildName = entry.getKey().equals(":") ? null : entry.getKey();
                EclipseProject rootEclipseProject = entry.getValue();
                builds.add(new BuildNode(buildTreeNode, rootEclipseProject, includedBuildName));
            }
        }
        List<FaultyBuildTreeNode> faultyBuildNodes = faultyBuilds.stream().map(b -> new FaultyBuildTreeNode(b.getBuildConfig())).collect(Collectors.toList());
        return new TaskViewContent(builds, faultyBuildNodes);
    }
}

