/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Objects;
import java.util.Map;
import org.eclipse.buildship.core.internal.util.gradle.Path;
import org.eclipse.buildship.ui.internal.view.task.BuildInvocations;
import org.eclipse.buildship.ui.internal.view.task.BuildTreeNode;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class BuildNode {
    private final BuildTreeNode buildTreeNode;
    private final EclipseProject rootEclipseProject;
    private final String includedBuildName;
    private final Map<Path, BuildInvocations> allBuildInvocations;

    public BuildNode(BuildTreeNode buildTreeNode, EclipseProject rootEclipseProject, String includedBuildName) {
        this.buildTreeNode = buildTreeNode;
        this.rootEclipseProject = rootEclipseProject;
        this.includedBuildName = includedBuildName;
        this.allBuildInvocations = BuildInvocations.collectAll(rootEclipseProject.getGradleProject());
    }

    public BuildTreeNode getBuildTreeNode() {
        return this.buildTreeNode;
    }

    public boolean isIncludedBuild() {
        return this.includedBuildName != null;
    }

    public String getIncludedBuildName() {
        return this.includedBuildName;
    }

    public EclipseProject getRootEclipseProject() {
        return this.rootEclipseProject;
    }

    public BuildInvocations buildInvocationsFor(Path path) {
        return this.allBuildInvocations.get(path);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BuildNode that = (BuildNode)other;
        return Objects.equal((Object)this.buildTreeNode, (Object)that.buildTreeNode) && Objects.equal((Object)this.rootEclipseProject, (Object)that.rootEclipseProject) && Objects.equal((Object)this.includedBuildName, (Object)that.includedBuildName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.buildTreeNode, this.rootEclipseProject, this.includedBuildName});
    }
}

