/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.execution;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.BaseRunConfiguration;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.operation.ToolingApiJob;
import org.eclipse.buildship.core.internal.util.gradle.Path;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.ModelProvider;
import org.eclipse.buildship.ui.internal.UiPlugin;
import org.eclipse.buildship.ui.internal.util.editor.EditorUtils;
import org.eclipse.buildship.ui.internal.view.execution.OperationItem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class OpenTestSourceFileJob
extends ToolingApiJob<Void> {
    private final ImmutableList<OperationItem> operationItems;
    private final BaseRunConfiguration runConfig;

    public OpenTestSourceFileJob(List<OperationItem> operationItems, BaseRunConfiguration baseLaunchConfiguration) {
        super("Opening test source files");
        this.operationItems = ImmutableList.copyOf(operationItems);
        this.runConfig = (BaseRunConfiguration)Preconditions.checkNotNull((Object)baseLaunchConfiguration);
    }

    public Void runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
        this.openTestSourceFile(tokenSource, monitor);
        return null;
    }

    protected void openTestSourceFile(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.operationItems.size());
        for (OperationItem operationItem : this.operationItems) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.searchForTestSource(operationItem, tokenSource, subMonitor.newChild(1));
        }
    }

    private void searchForTestSource(OperationItem operationItem, CancellationTokenSource tokenSource, SubMonitor monitor) throws CoreException {
        OperationDescriptor operationDescriptor = (OperationDescriptor)operationItem.getAdapter(OperationDescriptor.class);
        if (operationDescriptor instanceof JvmTestOperationDescriptor) {
            JvmTestOperationDescriptor testOperationDescriptor = (JvmTestOperationDescriptor)operationDescriptor;
            String className = testOperationDescriptor.getClassName();
            Optional<Path> projectPath = this.findProjectPath(operationDescriptor);
            if (className != null && projectPath.isPresent()) {
                String methodName = testOperationDescriptor.getMethodName();
                this.searchForTestSource(className, methodName, (Path)projectPath.get(), tokenSource, monitor);
            }
        }
    }

    private Optional<Path> findProjectPath(OperationDescriptor operationDescriptor) {
        OperationDescriptor parent = operationDescriptor.getParent();
        if (parent != null) {
            if (parent instanceof TaskOperationDescriptor) {
                Path taskPath = Path.from((String)((TaskOperationDescriptor)parent).getTaskPath());
                return Optional.of((Object)taskPath.dropLastSegment());
            }
            return this.findProjectPath(parent);
        }
        return Optional.absent();
    }

    private void searchForTestSource(String className, String methodName, Path projectPath, CancellationTokenSource tokenSource, SubMonitor monitor) throws CoreException {
        monitor.setTaskName(String.format("Open test source file for class %s.", className));
        monitor.setWorkRemaining(2);
        List<IProject> project = this.findProjectContainingTest(projectPath, tokenSource, (IProgressMonitor)monitor);
        boolean found = this.searchForJavaTest(className, methodName, project, (IProgressMonitor)monitor.newChild(1));
        if (!found) {
            this.searchForGroovyTest(className, methodName, project, monitor.newChild(1));
        }
    }

    private boolean searchForJavaTest(String className, String methodName, List<IProject> projects, IProgressMonitor monitor) throws CoreException {
        SearchEngine searchEngine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((String)className, (int)0, (int)0, (int)0);
        ShowTestSourceFileSearchRequester requester = new ShowTestSourceFileSearchRequester(methodName);
        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.createSearchScope(projects, monitor), (SearchRequestor)requester, monitor);
        return requester.isFoundJavaTestSourceFile();
    }

    private void searchForGroovyTest(String className, String methodName, List<IProject> projects, SubMonitor monitor) throws CoreException {
        ShowTestSourceFileResourceVisitor visitor = new ShowTestSourceFileResourceVisitor(methodName, className, (List)ImmutableList.of((Object)"groovy"));
        if (projects.isEmpty()) {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)visitor);
        } else {
            for (IProject project : projects) {
                project.accept((IResourceVisitor)visitor);
            }
        }
    }

    private List<IProject> findProjectContainingTest(Path projectPath, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        File workingDir = this.runConfig.getProjectConfiguration().getProjectDir();
        Optional project = CorePlugin.workspaceOperations().findProjectByLocation(workingDir);
        if (!project.isPresent()) {
            return Collections.emptyList();
        }
        BuildConfiguration buildConfig = CorePlugin.configurationManager().loadProjectConfiguration((IProject)project.get()).getBuildConfiguration();
        ModelProvider modelProvider = CorePlugin.internalGradleWorkspace().getGradleBuild(buildConfig).getModelProvider();
        Collection<EclipseProject> eclipseProjects = OpenTestSourceFileJob.collectAll(modelProvider.fetchModels(EclipseProject.class, FetchStrategy.LOAD_IF_NOT_CACHED, tokenSource, monitor).values());
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (EclipseProject eclipseProject : eclipseProjects) {
            Optional workspaceProject;
            Path path = Path.from((String)eclipseProject.getGradleProject().getPath());
            if (!path.equals((Object)projectPath) || !(workspaceProject = CorePlugin.workspaceOperations().findProjectByName(eclipseProject.getName())).isPresent() || !((IProject)workspaceProject.get()).isAccessible()) continue;
            result.add((IProject)workspaceProject.get());
        }
        return result;
    }

    private static Collection<EclipseProject> collectAll(Collection<EclipseProject> projects) {
        ArrayList result = Lists.newArrayList();
        for (EclipseProject eclipseProject : projects) {
            result.add(eclipseProject);
            OpenTestSourceFileJob.collectAll((Collection<? extends EclipseProject>)eclipseProject.getChildren(), result);
        }
        return result;
    }

    private static void collectAll(Collection<? extends EclipseProject> projects, Collection<EclipseProject> result) {
        for (EclipseProject eclipseProject : projects) {
            result.add(eclipseProject);
            OpenTestSourceFileJob.collectAll((Collection<? extends EclipseProject>)eclipseProject.getChildren(), result);
        }
    }

    private IJavaSearchScope createSearchScope(List<IProject> projects, IProgressMonitor monitor) throws CoreException {
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        for (IProject project : projects) {
            if (!project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) continue;
            javaProjects.add(JavaCore.create((IProject)project));
        }
        if (javaProjects.isEmpty()) {
            return SearchEngine.createWorkspaceScope();
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])((IJavaElement[])javaProjects.toArray(new IJavaProject[0])));
    }

    private static final class ShowTestSourceFileResourceVisitor
    implements IResourceVisitor {
        private static final String BIN_FOLDER_NAME = "bin";
        private final String methodName;
        private final String className;
        private final ImmutableList<String> fileExtensions;

        private ShowTestSourceFileResourceVisitor(String methodName, String className, List<String> fileExtensions) {
            this.methodName = methodName;
            this.className = (String)Preconditions.checkNotNull((Object)className);
            this.fileExtensions = ImmutableList.copyOf(fileExtensions);
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() != 1 || !this.fileExtensions.contains((Object)resource.getFileExtension())) {
                return true;
            }
            String classNameToPath = this.className.replaceAll(Pattern.quote("."), "/");
            String projectRelativePath = resource.getProjectRelativePath().toString();
            if (projectRelativePath.startsWith(BIN_FOLDER_NAME) || !projectRelativePath.contains(classNameToPath)) {
                return true;
            }
            final IFile file = (IFile)resource.getAdapter(IFile.class);
            if (file == null) {
                return true;
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    IEditorPart editor = EditorUtils.openInInternalEditor(file, true);
                    IRegion region = this.getClassOrMethodRegion(file);
                    if (region != null) {
                        EditorUtils.selectAndReveal(region.getOffset(), region.getLength(), editor, file);
                    }
                }
            });
            return false;
        }

        private IRegion getClassOrMethodRegion(IFile file) {
            if (this.methodName == null) {
                try {
                    FindReplaceDocumentAdapter documentAdapter = this.createFindReplaceDocumentAdapter(file);
                    return this.find(documentAdapter, Files.getNameWithoutExtension((String)file.getName()));
                }
                catch (Exception e) {
                    return null;
                }
            }
            try {
                FindReplaceDocumentAdapter documentAdapter = this.createFindReplaceDocumentAdapter(file);
                IRegion region = this.find(documentAdapter, this.methodName);
                if (region == null) {
                    documentAdapter = this.createFindReplaceDocumentAdapter(file);
                    return this.find(documentAdapter, Files.getNameWithoutExtension((String)file.getName()));
                }
                return region;
            }
            catch (Exception e) {
                return null;
            }
        }

        private FindReplaceDocumentAdapter createFindReplaceDocumentAdapter(IFile file) throws CoreException {
            TextFileDocumentProvider textFileDocumentProvider = new TextFileDocumentProvider();
            textFileDocumentProvider.connect((Object)file);
            IDocument document = textFileDocumentProvider.getDocument((Object)file);
            return new FindReplaceDocumentAdapter(document);
        }

        private IRegion find(FindReplaceDocumentAdapter findReplaceDocumentAdapter, String findString) throws BadLocationException {
            return findReplaceDocumentAdapter.find(0, findString, true, true, false, false);
        }
    }

    private final class ShowTestSourceFileSearchRequester
    extends SearchRequestor {
        private final String methodName;
        private final AtomicBoolean foundJavaTestSourceFile;

        private ShowTestSourceFileSearchRequester(String methodName) {
            this.methodName = methodName;
            this.foundJavaTestSourceFile = new AtomicBoolean(false);
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match.getElement() instanceof IType) {
                this.foundJavaTestSourceFile.set(true);
                IType classElement = (IType)match.getElement();
                IJavaElement methodElement = this.findMethod(this.methodName, classElement);
                this.openInEditor((IJavaElement)(methodElement != null ? methodElement : classElement));
            }
        }

        private IJavaElement findMethod(String methodName, IType type) {
            IStatus status = JavaConventionsUtil.validateMethodName((String)methodName, (IJavaElement)type);
            if (!status.isOK()) {
                return null;
            }
            IMethod method = type.getMethod(methodName, new String[0]);
            if (method != null && method.exists()) {
                return method;
            }
            try {
                for (IMethod methodItem : type.getMethods()) {
                    if (!methodItem.getElementName().equals(methodName)) continue;
                    return methodItem;
                }
                return null;
            }
            catch (JavaModelException e) {
                return null;
            }
        }

        private void openInEditor(final IJavaElement javaElement) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        JavaUI.openInEditor((IJavaElement)javaElement);
                    }
                    catch (Exception e) {
                        String message = String.format("Cannot open Java element %s in editor.", javaElement);
                        UiPlugin.logger().error(message, (Throwable)e);
                    }
                }
            });
        }

        private boolean isFoundJavaTestSourceFile() {
            return this.foundJavaTestSourceFile.get();
        }
    }
}

