/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.execution;

import com.google.common.collect.ImmutableMap;
import org.eclipse.buildship.ui.internal.PluginImage;
import org.eclipse.buildship.ui.internal.PluginImages;
import org.eclipse.buildship.ui.internal.util.color.ColorUtils;
import org.eclipse.buildship.ui.internal.view.execution.OperationItem;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.SkippedResult;
import org.gradle.tooling.events.SuccessResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.events.test.TestOperationDescriptor;
import org.gradle.tooling.events.test.TestOutputDescriptor;

public final class ExecutionPageNameLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final ImmutableMap<String, ColorDescriptor> customTextToColor;
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public ExecutionPageNameLabelProvider() {
        ColorDescriptor decorationsColor = ColorUtils.getDecorationsColorDescriptorFromCurrentTheme();
        this.customTextToColor = ImmutableMap.of((Object)"UP-TO-DATE", (Object)decorationsColor, (Object)"FROM-CACHE", (Object)decorationsColor);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof OperationItem) {
            OperationItem operationItem = (OperationItem)element;
            String rawLabel = ExecutionPageNameLabelProvider.renderCompact(operationItem);
            StyledString styledLabel = new StyledString(rawLabel);
            for (String text : this.customTextToColor.keySet()) {
                this.assignColorToText(rawLabel, styledLabel, text);
            }
            return styledLabel;
        }
        return null;
    }

    public static String renderVerbose(FinishEvent finishEvent) {
        OperationDescriptor descriptor = finishEvent.getDescriptor();
        return ExecutionPageNameLabelProvider.render(descriptor, finishEvent, true);
    }

    public static String renderCompact(OperationItem operationItem) {
        OperationDescriptor descriptor = operationItem.getDescriptor();
        FinishEvent finishEvent = operationItem.getFinishEvent();
        return ExecutionPageNameLabelProvider.render(descriptor, finishEvent, false);
    }

    private static String render(OperationDescriptor descriptor, FinishEvent finishEvent, boolean verbose) {
        if (descriptor instanceof TaskOperationDescriptor) {
            return ExecutionPageNameLabelProvider.renderTask(finishEvent, (TaskOperationDescriptor)descriptor, verbose);
        }
        if (descriptor instanceof TestOperationDescriptor) {
            return ExecutionPageNameLabelProvider.renderTest(descriptor, verbose);
        }
        if (descriptor instanceof TestOutputDescriptor) {
            return ExecutionPageNameLabelProvider.renderTestOutput((TestOutputDescriptor)descriptor);
        }
        return ExecutionPageNameLabelProvider.renderOther(descriptor);
    }

    private static String renderTask(FinishEvent finishEvent, TaskOperationDescriptor descriptor, boolean verbose) {
        StringBuilder task = new StringBuilder();
        if (verbose) {
            task.append("Task ");
        }
        task.append(descriptor.getTaskPath());
        if (finishEvent instanceof TaskFinishEvent && finishEvent.getResult() instanceof TaskSuccessResult) {
            TaskSuccessResult taskResult = (TaskSuccessResult)finishEvent.getResult();
            if (taskResult.isFromCache()) {
                task.append(" FROM-CACHE");
            } else if (taskResult.isUpToDate()) {
                task.append(" UP-TO-DATE");
            }
        }
        return task.toString();
    }

    private static String renderTest(OperationDescriptor descriptor, boolean verbose) {
        if (verbose) {
            return String.format("Test '%s'", descriptor.getName());
        }
        return descriptor.getName();
    }

    private static String renderTestOutput(TestOutputDescriptor descriptor) {
        return String.format("%s: %s", descriptor.getDestination().toString(), descriptor.getMessage());
    }

    private static String renderOther(OperationDescriptor descriptor) {
        return descriptor.getDisplayName();
    }

    private void assignColorToText(String rawLabel, StyledString styledLabel, final String text) {
        int index = rawLabel.indexOf(text);
        if (index >= 0) {
            StyledString.Styler styler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    ColorDescriptor substringColorDescriptor = (ColorDescriptor)ExecutionPageNameLabelProvider.this.customTextToColor.get((Object)text);
                    textStyle.foreground = ExecutionPageNameLabelProvider.this.resourceManager.createColor(substringColorDescriptor);
                }
            };
            styledLabel.setStyle(index, text.length(), styler);
        }
    }

    public Image getImage(Object element) {
        return element instanceof OperationItem ? this.calculateImage((OperationItem)element) : null;
    }

    private Image calculateImage(OperationItem operationItem) {
        if (operationItem.getFinishEvent() != null) {
            OperationResult result = operationItem.getFinishEvent().getResult();
            if (result instanceof FailureResult) {
                return PluginImages.OPERATION_FAILURE.withState(PluginImage.ImageState.ENABLED).getImage();
            }
            if (result instanceof SkippedResult) {
                return PluginImages.OPERATION_SKIPPED.withState(PluginImage.ImageState.ENABLED).getImage();
            }
            if (result instanceof SuccessResult) {
                return PluginImages.OPERATION_SUCCESS.withState(PluginImage.ImageState.ENABLED).getImage();
            }
            return null;
        }
        return PluginImages.OPERATION_IN_PROGRESS.withState(PluginImage.ImageState.ENABLED).getImage();
    }

    public void dispose() {
        this.resourceManager.dispose();
    }
}

