/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.navigator;

import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.TraceScope;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.ui.internal.UiPlugin;
import org.eclipse.buildship.ui.internal.UiTraceScopes;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public final class BuildFolderViewerFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IFolder) {
            return !BuildFolderViewerFilter.isBuildFolderInPersistentModel((IFolder)element);
        }
        return true;
    }

    public static boolean isBuildFolderInPersistentModel(IFolder folder) {
        try {
            IProject project = folder.getProject();
            PersistentModel model = CorePlugin.modelPersistence().loadModel(project);
            if (!model.isPresent()) {
                return false;
            }
            IPath modelBuildDir = model.getBuildDir();
            return modelBuildDir == null ? false : folder.getProjectRelativePath().equals((Object)modelBuildDir);
        }
        catch (Exception e) {
            UiPlugin.logger().trace((TraceScope)UiTraceScopes.NAVIGATOR, String.format("Could not check whether folder %s is a build folder.", folder.getFullPath()), (Throwable)e);
            return false;
        }
    }
}

