/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import org.gradle.util.GradleVersion;

public class DocumentationRegistry {
    private final GradleVersion gradleVersion = GradleVersion.current();

    public String getDocumentationFor(String id) {
        return String.format("https://docs.gradle.org/%s/userguide/%s.html", this.gradleVersion.getVersion(), id);
    }

    public String getDocumentationFor(String id, String section) {
        return String.format("https://docs.gradle.org/%s/userguide/%s.html#%s", this.gradleVersion.getVersion(), id, section);
    }

    public String getDslRefForProperty(Class<?> clazz, String property) {
        String className = clazz.getName();
        return String.format("https://docs.gradle.org/%s/dsl/%s.html#%s:%s", this.gradleVersion.getVersion(), className, className, property);
    }

    public String getGuideFor(String guide) {
        return String.format("https://guides.gradle.org/%s", guide);
    }

    public String getTopicGuidesFor(String topic) {
        return String.format("https://guides.gradle.org?q=%s", topic);
    }
}

