/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.workspace;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.util.collections.AdapterFunction;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.buildship.core.internal.workspace.SynchronizationJob;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddBuildshipNatureHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            List elements = ((StructuredSelection)selection).toList();
            Set<IProject> projects = this.collectProjects(elements);
            Set<BuildConfiguration> buildConfigs = this.createBuildConfigsFor(projects);
            this.synchronize(buildConfigs);
        }
        return null;
    }

    private Set<IProject> collectProjects(List<?> elements) {
        LinkedHashSet projects = Sets.newLinkedHashSet();
        AdapterFunction adapterFunction = AdapterFunction.forType(IProject.class);
        for (Object element : elements) {
            IProject project = (IProject)adapterFunction.apply(element);
            if (project == null || GradleProjectNature.isPresentOn((IProject)project) || project.getLocation() == null) continue;
            projects.add(project);
        }
        return projects;
    }

    private Set<BuildConfiguration> createBuildConfigsFor(Set<IProject> projects) {
        LinkedHashSet buildConfigs = Sets.newLinkedHashSet();
        for (IProject project : projects) {
            buildConfigs.add(BuildConfiguration.forRootProjectDirectory((File)project.getLocation().toFile()).build());
        }
        return buildConfigs;
    }

    private void synchronize(Set<BuildConfiguration> buildConfigs) {
        HashSet gradleBuilds = Sets.newHashSet();
        for (BuildConfiguration buildConfig : buildConfigs) {
            gradleBuilds.add(GradleCore.getWorkspace().createBuild(buildConfig));
        }
        new SynchronizationJob(NewProjectHandler.IMPORT_AND_MERGE, (Iterable)gradleBuilds).schedule();
    }
}

