/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.ui.launch.SelectionJavaElementResolver;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;

public final class TestlaunchShortcutValidator {
    private TestlaunchShortcutValidator() {
    }

    public static boolean validateElements(Collection<? extends IJavaElement> javaElements) {
        ImmutableList elements = ImmutableList.copyOf(javaElements);
        if (elements.isEmpty()) {
            return false;
        }
        for (IJavaElement element : elements) {
            if (element.getJavaProject() != null && element.getJavaProject().getProject() != null) continue;
            return false;
        }
        IProject project = ((IJavaElement)elements.get(0)).getJavaProject().getProject();
        for (int i = 0; i < javaElements.size(); ++i) {
            if (((IJavaElement)elements.get(i)).getJavaProject().getProject().equals(project)) continue;
            return false;
        }
        return project.isAccessible() && GradleProjectNature.INSTANCE.isPresentOn(project);
    }

    public static final class PropertyTester
    extends org.eclipse.core.expressions.PropertyTester {
        private static final String PROPERTY_NAME_SELECTION_CAN_BE_LAUNCHED_AS_TEST = "selectioncanbelaunchedastest";

        public boolean test(Object receiver, String propertyString, Object[] args, Object expectedValue) {
            if (propertyString.equals(PROPERTY_NAME_SELECTION_CAN_BE_LAUNCHED_AS_TEST)) {
                return receiver instanceof Collection && PropertyTester.selectionCanBeLaunchedAsTest((Collection)receiver);
            }
            throw new GradlePluginsRuntimeException("Not recognized property to test: " + propertyString);
        }

        private static boolean selectionCanBeLaunchedAsTest(Collection<? extends Object> elements) {
            SelectionJavaElementResolver elementResolver = SelectionJavaElementResolver.from(elements);
            return TestlaunchShortcutValidator.validateElements(elementResolver.resolveTypes()) || TestlaunchShortcutValidator.validateElements(elementResolver.resolveMethods());
        }
    }
}

