/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.nodeselection;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class NodeSelection {
    private static final NodeSelection EMPTY = new NodeSelection((List<?>)ImmutableList.of());
    private final ImmutableList<?> nodes;

    private NodeSelection(List<?> nodes) {
        this.nodes = ImmutableList.copyOf(nodes);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public boolean isSingleSelection() {
        return this.nodes.size() == 1;
    }

    public Object getFirstNode() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Selection is empty.");
        }
        return this.nodes.get(0);
    }

    public <T> T getFirstNode(Class<T> expectedType) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Selection is empty.");
        }
        return expectedType.cast(this.nodes.get(0));
    }

    public ImmutableList<?> getNodes() {
        return this.nodes;
    }

    public <T> ImmutableList<T> getNodes(final Class<T> expectedType) {
        return FluentIterable.from(this.nodes).transform(new Function<Object, T>(){

            public T apply(Object input) {
                return expectedType.cast(input);
            }
        }).toList();
    }

    public boolean hasAllNodesOfType(Class<?> expectedType) {
        return this.allMatch((Predicate<Object>)Predicates.instanceOf(expectedType));
    }

    public boolean allMatch(Predicate<Object> predicate) {
        return FluentIterable.from(this.nodes).allMatch(predicate);
    }

    public NodeSelection mergeWith(NodeSelection newSelection) {
        if (newSelection.isEmpty()) {
            return NodeSelection.empty();
        }
        ArrayList result = Lists.newArrayList(this.nodes);
        result.retainAll((Collection<?>)newSelection.getNodes());
        ImmutableList<?> newlySelected = this.removeAll((List<?>)newSelection.getNodes(), result);
        result.addAll(newlySelected);
        return new NodeSelection(result);
    }

    private ImmutableList<?> removeAll(List<?> toRemoveFrom, final List<?> elementsToRemove) {
        return FluentIterable.from(toRemoveFrom).filter((Predicate)new Predicate<Object>(){

            public boolean apply(Object node) {
                return !elementsToRemove.contains(node);
            }
        }).toList();
    }

    public static NodeSelection empty() {
        return EMPTY;
    }

    public static NodeSelection from(IStructuredSelection selection) {
        return selection.isEmpty() ? NodeSelection.empty() : new NodeSelection(selection.toList());
    }

    public static NodeSelection from(ISelection selection) {
        return selection instanceof IStructuredSelection ? NodeSelection.from((IStructuredSelection)selection) : NodeSelection.empty();
    }
}

