/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.test.TestOperationDescriptor;

public final class TestConfig {
    private final ImmutableList<String> jvmTestClasses;
    private final ImmutableList<? extends TestOperationDescriptor> tests;
    private final ImmutableMap<String, List<String>> jvmTestMethods;

    private TestConfig(List<String> jvmTestClasses, List<? extends TestOperationDescriptor> tests, Map<String, List<String>> jvmTestMethods) {
        this.jvmTestClasses = ImmutableList.copyOf(jvmTestClasses);
        this.tests = ImmutableList.copyOf(tests);
        this.jvmTestMethods = ImmutableMap.copyOf(jvmTestMethods);
        this.checkNotAllListsEmpty(jvmTestClasses, tests, jvmTestMethods);
    }

    private void checkNotAllListsEmpty(List<String> jvmTestClasses, List<? extends TestOperationDescriptor> tests, Map<String, List<String>> jvmTestMethods) {
        Preconditions.checkArgument((!jvmTestClasses.isEmpty() || !tests.isEmpty() || !jvmTestMethods.isEmpty() ? 1 : 0) != 0, (Object)"Either JVM test classes or test operations, or both, must be specified.");
    }

    public void apply(TestLauncher testLauncher) {
        Preconditions.checkNotNull((Object)testLauncher);
        testLauncher.withJvmTestClasses(this.jvmTestClasses);
        testLauncher.withTests(this.tests);
        for (String jvmTestClass : this.jvmTestMethods.keySet()) {
            testLauncher.withJvmTestMethods(jvmTestClass, (Iterable)this.jvmTestMethods.get((Object)jvmTestClass));
        }
    }

    public static TestConfig forJvmTestClasses(String ... jvmTestClasses) {
        return new Builder().jvmTestClasses(jvmTestClasses).build();
    }

    public static TestConfig forJvmTestClasses(Iterable<String> jvmTestClasses) {
        return new Builder().jvmTestClasses(jvmTestClasses).build();
    }

    public static TestConfig forTests(TestOperationDescriptor ... tests) {
        return new Builder().tests(tests).build();
    }

    public static TestConfig forTests(Iterable<? extends TestOperationDescriptor> tests) {
        return new Builder().tests(tests).build();
    }

    public static TestConfig forJvmTestMethods(String jvmTestClass, String ... jvmTestMethods) {
        return new Builder().jvmTestMethods(jvmTestClass, Arrays.asList(jvmTestMethods)).build();
    }

    public static TestConfig forJvmTestMethods(String jvmTestClass, Iterable<String> jvmTestMethods) {
        return new Builder().jvmTestMethods(jvmTestClass, jvmTestMethods).build();
    }

    public static TestConfig forJvmTestMethods(Map<String, Iterable<String>> jvmTestMethods) {
        Builder result = new Builder();
        for (String jvmTestClass : jvmTestMethods.keySet()) {
            result.jvmTestMethods(jvmTestClass, jvmTestMethods.get(jvmTestClass));
        }
        return result.build();
    }

    public static final class Builder {
        private ImmutableList.Builder<String> jvmTestClasses = ImmutableList.builder();
        private ImmutableList.Builder<TestOperationDescriptor> tests = ImmutableList.builder();
        private ImmutableMap.Builder<String, List<String>> jvmTestMethods = ImmutableMap.builder();

        public Builder jvmTestClasses(String ... jvmTestClasses) {
            this.jvmTestClasses.addAll(Arrays.asList(jvmTestClasses));
            return this;
        }

        public Builder jvmTestClasses(Iterable<String> jvmTestClasses) {
            this.jvmTestClasses.addAll(jvmTestClasses);
            return this;
        }

        public Builder tests(TestOperationDescriptor ... tests) {
            this.tests.addAll(Arrays.asList(tests));
            return this;
        }

        public Builder jvmTestMethods(String jvmTestClass, Iterable<String> jvmTestMethods) {
            this.jvmTestMethods.put((Object)jvmTestClass, (Object)ImmutableList.copyOf(jvmTestMethods));
            return this;
        }

        public Builder tests(Iterable<? extends TestOperationDescriptor> tests) {
            this.tests.addAll(tests);
            return this;
        }

        public TestConfig build() {
            return new TestConfig((List)this.jvmTestClasses.build(), (List)this.tests.build(), (Map)this.jvmTestMethods.build());
        }
    }
}

