/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import org.eclipse.buildship.ui.view.execution.OperationItem;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.events.test.TestOperationDescriptor;

public final class OperationDescriptorRenderer {
    private OperationDescriptorRenderer() {
    }

    public static String renderVerbose(FinishEvent finishEvent) {
        OperationDescriptor descriptor = finishEvent.getDescriptor();
        if (descriptor instanceof TaskOperationDescriptor) {
            String taskPath = ((TaskOperationDescriptor)descriptor).getTaskPath();
            return OperationDescriptorRenderer.taskIsUpToDate(finishEvent) ? String.format("Task %s UP-TO-DATE", taskPath) : String.format("Task %s", taskPath);
        }
        if (descriptor instanceof TestOperationDescriptor) {
            return String.format("Test '%s'", descriptor.getName());
        }
        return descriptor.getDisplayName();
    }

    public static String renderCompact(OperationItem operationItem) {
        OperationDescriptor descriptor = operationItem.getStartEvent().getDescriptor();
        if (descriptor instanceof TaskOperationDescriptor) {
            String taskPath = ((TaskOperationDescriptor)descriptor).getTaskPath();
            return OperationDescriptorRenderer.taskIsUpToDate(operationItem.getFinishEvent()) ? String.format("%s UP-TO-DATE", taskPath) : taskPath;
        }
        if (descriptor instanceof TestOperationDescriptor) {
            return descriptor.getName();
        }
        return descriptor.getDisplayName();
    }

    private static boolean taskIsUpToDate(FinishEvent finishEvent) {
        TaskFinishEvent taskFinishEvent;
        if (finishEvent instanceof TaskFinishEvent && (taskFinishEvent = (TaskFinishEvent)finishEvent).getResult() instanceof TaskSuccessResult) {
            TaskSuccessResult taskSuccessResult = (TaskSuccessResult)taskFinishEvent.getResult();
            return taskSuccessResult.isUpToDate();
        }
        return false;
    }
}

