/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.workspace;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.OmniGradleBuildStructure;
import com.gradleware.tooling.toolingmodel.OmniGradleProjectStructure;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.gradle.tooling.GradleConnector;

public final class RefreshGradleClasspathContainerHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Set<OmniGradleProjectStructure> rootProjects = this.collectSelectedRootGradleProjects(event);
        for (IJavaProject javaProject : this.collectAllRelatedWorkspaceProjects(rootProjects)) {
            GradleClasspathContainer.requestUpdateOf((IJavaProject)javaProject);
        }
        return null;
    }

    private List<IJavaProject> collectAllRelatedWorkspaceProjects(Set<OmniGradleProjectStructure> rootProjects) {
        ImmutableSet<String> allProjectNames = this.getAllProjectNames(rootProjects);
        return this.getExistingJavaProjects(allProjectNames);
    }

    private ImmutableSet<String> getAllProjectNames(Set<OmniGradleProjectStructure> rootProjects) {
        ImmutableSet.Builder relatedProjects = ImmutableSet.builder();
        for (OmniGradleProjectStructure rootProject : rootProjects) {
            relatedProjects.addAll(this.getAllProjectNamesInGradleRootProject(rootProject));
        }
        return relatedProjects.build();
    }

    private List<String> getAllProjectNamesInGradleRootProject(OmniGradleProjectStructure root) {
        ImmutableList.Builder result = ImmutableList.builder();
        result.add((Object)root.getName());
        for (OmniGradleProjectStructure child : root.getChildren()) {
            result.add((Object)child.getName());
        }
        return result.build();
    }

    private List<IJavaProject> getExistingJavaProjects(final ImmutableSet<String> projectNames) {
        return FluentIterable.from((Iterable)CorePlugin.workspaceOperations().getAllProjects()).filter((Predicate)new Predicate<IProject>(){

            public boolean apply(IProject project) {
                try {
                    return project.isAccessible() && projectNames.contains((Object)project.getName()) && project.hasNature("org.eclipse.jdt.core.javanature");
                }
                catch (CoreException e) {
                    throw new GradlePluginsRuntimeException((Exception)((Object)e));
                }
            }
        }).transform((Function)new Function<IProject, IJavaProject>(){

            public IJavaProject apply(IProject project) {
                return JavaCore.create((IProject)project);
            }
        }).toList();
    }

    private Set<OmniGradleProjectStructure> collectSelectedRootGradleProjects(ExecutionEvent event) {
        return FluentIterable.from(this.collectSelectedJavaProjects(event)).transform((Function)new Function<IJavaProject, OmniGradleProjectStructure>(){

            public OmniGradleProjectStructure apply(IJavaProject javaProject) {
                FixedRequestAttributes requestAttributes = CorePlugin.projectConfigurationManager().readProjectConfiguration(javaProject.getProject()).getRequestAttributes();
                ProcessStreams stream = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
                OmniGradleBuildStructure structure = CorePlugin.modelRepositoryProvider().getModelRepository(requestAttributes).fetchGradleBuildStructure(new TransientRequestAttributes(false, stream.getOutput(), stream.getError(), stream.getInput(), (List)ImmutableList.of(), (List)ImmutableList.of(), GradleConnector.newCancellationTokenSource().token()), FetchStrategy.LOAD_IF_NOT_CACHED);
                return structure.getRootProject();
            }
        }).toSet();
    }

    private List<IJavaProject> collectSelectedJavaProjects(ExecutionEvent event) {
        return FluentIterable.from(this.collectSelectedProjects(event)).filter((Predicate)new Predicate<IProject>(){

            public boolean apply(IProject project) {
                try {
                    return project.hasNature("org.eclipse.jdt.core.javanature");
                }
                catch (CoreException e) {
                    CorePlugin.logger().error("Failed to obtain java project for " + project, (Throwable)e);
                    return false;
                }
            }
        }).transform((Function)new Function<IProject, IJavaProject>(){

            public IJavaProject apply(IProject project) {
                return JavaCore.create((IProject)project);
            }
        }).toList();
    }

    private List<IProject> collectSelectedProjects(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ImmutableList.Builder result = ImmutableList.builder();
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)currentSelection;
            IAdapterManager adapterManager = Platform.getAdapterManager();
            for (Object selectionItem : selection.toList()) {
                IResource resource = (IResource)adapterManager.getAdapter(selectionItem, IResource.class);
                if (resource == null) continue;
                IProject project = resource.getProject();
                result.add((Object)project);
            }
        }
        return result.build();
    }
}

