/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.workbench;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public final class WorkingSetUtils {
    private WorkingSetUtils() {
    }

    public static IWorkingSet[] toWorkingSets(List<String> workingSetNames) {
        final IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        return (IWorkingSet[])FluentIterable.from(workingSetNames).transform((Function)new Function<String, IWorkingSet>(){

            public IWorkingSet apply(String name) {
                return workingSetManager.getWorkingSet(name);
            }
        }).filter(Predicates.notNull()).toArray(IWorkingSet.class);
    }

    public static List<String> toWorkingSetNames(List<IWorkingSet> workingSets) {
        return FluentIterable.from(workingSets).transform((Function)new Function<IWorkingSet, String>(){

            public String apply(IWorkingSet workingSet) {
                return workingSet.getName();
            }
        }).toList();
    }

    public static List<String> getSelectedWorkingSetNames(IStructuredSelection selection) {
        List<IWorkingSet> selectedWorkingSets = WorkingSetUtils.getSelectedWorkingSets(selection);
        return WorkingSetUtils.toWorkingSetNames(selectedWorkingSets);
    }

    public static List<IWorkingSet> getSelectedWorkingSets(IStructuredSelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return ImmutableList.of();
        }
        List elements = selection.toList();
        ImmutableList workingSets = FluentIterable.from((Iterable)elements).filter(Predicates.instanceOf(IWorkingSet.class)).toList();
        return workingSets;
    }
}

