/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.predicate;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.List;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class Predicates {
    private Predicates() {
    }

    public static Predicate<Object> hasGradleNature() {
        return new Predicate<Object>(){

            public boolean apply(Object adaptable) {
                IProject project = (IProject)Platform.getAdapterManager().getAdapter(adaptable, IProject.class);
                if (project != null) {
                    return Predicates.hasGradleNature(project);
                }
                if (adaptable instanceof PackageFragmentRootContainer) {
                    project = ((PackageFragmentRootContainer)adaptable).getJavaProject().getProject();
                    return Predicates.hasGradleNature(project);
                }
                if (adaptable instanceof IStructuredSelection) {
                    List selections = ((IStructuredSelection)adaptable).toList();
                    return FluentIterable.from((Iterable)selections).anyMatch(Predicates.hasGradleNature());
                }
                return false;
            }
        };
    }

    private static boolean hasGradleNature(IProject project) {
        try {
            return GradleProjectNature.INSTANCE.isPresentOn(project);
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

