/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.gradleware.tooling.toolingutils.binding.Validator;
import java.io.File;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.util.binding.Validators;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.variable.ExpressionUtils;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.launch.LaunchMessages;
import org.eclipse.buildship.ui.util.file.DirectoryDialogSelectionListener;
import org.eclipse.buildship.ui.util.font.FontUtils;
import org.eclipse.buildship.ui.util.widget.UiBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public final class GradleUserHomeTab
extends AbstractLaunchConfigurationTab {
    private final Font defaultFont = FontUtils.getDefaultDialogFont();
    private final UiBuilder.UiBuilderFactory builderFactory = new UiBuilder.UiBuilderFactory(this.defaultFont);
    private final Validator<File> gradleUserHomeValidator = Validators.optionalDirectoryValidator((String)CoreMessages.RunConfiguration_Label_GradleUserHome);
    private Text gradleUserHomeText;

    public String getName() {
        return LaunchMessages.Tab_Name_GradleUserHome;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").createImage();
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        page.setLayout((Layout)layout);
        this.setControl((Control)page);
        Group gradleUserHomeGroup = this.createGroup(page, CoreMessages.RunConfiguration_Label_GradleUserHome + ":");
        this.createGradleUserHomeSelectionControl((Composite)gradleUserHomeGroup);
    }

    private Group createGroup(Composite parent, String groupName) {
        Group group = new Group(parent, 0);
        group.setText(groupName);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        return group;
    }

    private void createGradleUserHomeSelectionControl(Composite root) {
        this.gradleUserHomeText = this.builderFactory.newText(root).alignFillHorizontal().control();
        this.gradleUserHomeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                GradleUserHomeTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button gradleUserHomeBrowseButton = this.builderFactory.newButton(root).alignLeft().text(UiMessages.Button_Label_Browse).control();
        gradleUserHomeBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(root.getShell(), (Widget)this.gradleUserHomeText, CoreMessages.RunConfiguration_Label_GradleUserHome));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        GradleRunConfigurationAttributes configurationAttributes = GradleRunConfigurationAttributes.from((ILaunchConfiguration)configuration);
        this.gradleUserHomeText.setText(Strings.nullToEmpty((String)configurationAttributes.getGradleUserHomeExpression()));
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        GradleRunConfigurationAttributes.applyGradleUserHomeExpression((String)Strings.emptyToNull((String)this.gradleUserHomeText.getText()), (ILaunchConfigurationWorkingCopy)configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String gradleUserHomeResolved;
        String gradleUserHomeExpression = Strings.emptyToNull((String)this.gradleUserHomeText.getText());
        try {
            gradleUserHomeResolved = ExpressionUtils.decode((String)gradleUserHomeExpression);
        }
        catch (CoreException e) {
            this.setErrorMessage(NLS.bind((String)LaunchMessages.ErrorMessage_CannotResolveExpression_0, (Object)gradleUserHomeExpression));
            return false;
        }
        File gradleUserHome = (File)FileUtils.getAbsoluteFile((String)gradleUserHomeResolved).orNull();
        Optional error = this.gradleUserHomeValidator.validate((Object)gradleUserHome);
        this.setErrorMessage((String)error.orNull());
        return !error.isPresent();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void dispose() {
        this.defaultFont.dispose();
        super.dispose();
    }
}

