/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.external.viewer;

import java.net.URL;
import org.eclipse.buildship.ui.external.viewer.BasicUIJob;
import org.eclipse.buildship.ui.external.viewer.PatternFilter;
import org.eclipse.buildship.ui.external.viewer.ViewerMessages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FilteredTree
extends Composite {
    private Text filterText;
    private Control clearButtonControl;
    private TreeViewer treeViewer;
    private Composite filterComposite;
    private PatternFilter patternFilter;
    private String initialText = "";
    private Job refreshJob;
    private boolean showFilterControls;
    private Composite treeComposite;
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String DISABLED_CLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";
    private static final String PRESSED_CLEAR_ICON = "org.eclipse.ui.internal.dialogs.PRESSED_CLEAR_ICON";
    private static final long SOFT_MAX_EXPAND_TIME = 200L;
    private static Boolean useNativeSearchField;
    private String previousFilterText;
    private boolean narrowingDown;

    public FilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, 0);
        this.init(treeStyle, filter);
    }

    protected FilteredTree(Composite parent) {
        super(parent, 0);
    }

    protected void init(int treeStyle, PatternFilter filter) {
        this.patternFilter = filter;
        this.setShowFilterControls(true);
        this.createControl(this.getParent(), treeStyle);
        this.createRefreshJob();
        this.setInitialText(ViewerMessages.FilteredTree_FilterMessage);
        this.setFont(this.getParent().getFont());
    }

    protected void createControl(Composite parent, int treeStyle) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (FilteredTree.useNativeSearchField(parent)) {
            this.filterComposite = new Composite((Composite)this, 0);
        } else {
            this.filterComposite = new Composite((Composite)this, 2048);
            this.filterComposite.setBackground(this.getDisplay().getSystemColor(25));
        }
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        this.filterComposite.setLayout((Layout)filterLayout);
        this.filterComposite.setFont(parent.getFont());
        this.createFilterControls(this.filterComposite);
        GridData gridData = new GridData(4, 1, true, false);
        this.filterComposite.setVisible(this.isShowFilterControls());
        gridData.exclude = !this.isShowFilterControls();
        this.filterComposite.setLayoutData((Object)gridData);
        this.treeComposite = new Composite((Composite)this, 0);
        GridLayout treeCompositeLayout = new GridLayout();
        treeCompositeLayout.marginHeight = 0;
        treeCompositeLayout.marginWidth = 0;
        this.treeComposite.setLayout((Layout)treeCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)data);
        this.createTreeControl(this.treeComposite, treeStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean useNativeSearchField(Composite composite) {
        if (useNativeSearchField == null) {
            useNativeSearchField = Boolean.FALSE;
            Text testText = null;
            try {
                testText = new Text(composite, 384);
                useNativeSearchField = new Boolean((testText.getStyle() & 0x100) != 0);
            }
            finally {
                if (testText != null) {
                    testText.dispose();
                }
            }
        }
        return useNativeSearchField;
    }

    protected Composite createFilterControls(Composite parent) {
        this.createFilterText(parent);
        this.createClearText(parent);
        if (this.clearButtonControl != null) {
            this.clearButtonControl.setVisible(false);
        }
        return parent;
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.treeViewer = this.doCreateTreeViewer(parent, style);
        GridData data = new GridData(4, 4, true, true);
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilteredTree.this.refreshJob.cancel();
            }
        });
        if (this.treeViewer instanceof NotifyingTreeViewer) {
            this.patternFilter.setUseCache(true);
        }
        this.treeViewer.addFilter((ViewerFilter)this.patternFilter);
        return this.treeViewer.getControl();
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new NotifyingTreeViewer(parent, style);
    }

    private TreeItem getFirstMatchingItem(TreeItem[] items) {
        for (TreeItem item : items) {
            if (this.patternFilter.isLeafMatch((Viewer)this.treeViewer, item.getData()) && this.patternFilter.isElementSelectable(item.getData())) {
                return item;
            }
            TreeItem treeItem = this.getFirstMatchingItem(item.getItems());
            if (treeItem == null) continue;
            return treeItem;
        }
        return null;
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        this.refreshJob.setSystem(true);
    }

    protected BasicUIJob doCreateRefreshJob() {
        return new BasicUIJob("Refresh Filter", this.getDisplay()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (FilteredTree.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = FilteredTree.this.getFilterString();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                boolean bl = initial = FilteredTree.this.initialText != null && FilteredTree.this.initialText.equals(text);
                if (initial) {
                    FilteredTree.this.patternFilter.setPattern(null);
                } else if (text != null) {
                    FilteredTree.this.patternFilter.setPattern(text);
                }
                Composite redrawFalseControl = FilteredTree.this.treeComposite != null ? FilteredTree.this.treeComposite : FilteredTree.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    if (!FilteredTree.this.narrowingDown) {
                        TreeItem[] is;
                        for (TreeItem item : is = FilteredTree.this.treeViewer.getTree().getItems()) {
                            if (!item.getExpanded()) continue;
                            FilteredTree.this.treeViewer.setExpandedState(item.getData(), true);
                        }
                    }
                    FilteredTree.this.treeViewer.refresh(true);
                    if (text.length() > 0 && !initial) {
                        TreeItem[] items = FilteredTree.this.getViewer().getTree().getItems();
                        int treeHeight = FilteredTree.this.getViewer().getTree().getBounds().height;
                        int numVisibleItems = treeHeight / FilteredTree.this.getViewer().getTree().getItemHeight();
                        long stopTime = 200L + System.currentTimeMillis();
                        boolean cancel = false;
                        if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                            cancel = true;
                        }
                        FilteredTree.this.updateToolbar(true);
                        if (cancel) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    } else {
                        FilteredTree.this.updateToolbar(false);
                    }
                }
                finally {
                    TreeItem[] items = FilteredTree.this.getViewer().getTree().getItems();
                    if (items.length > 0 && FilteredTree.this.getViewer().getTree().getSelectionCount() == 0) {
                        FilteredTree.this.treeViewer.getTree().setTopItem(items[0]);
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                for (int i = 0; !canceled && i < items.length; ++i) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                        continue;
                    }
                    Object itemData = item.getData();
                    if (itemData == null) continue;
                    if (!item.getExpanded()) {
                        FilteredTree.this.treeViewer.setExpandedState(itemData, true);
                    }
                    TreeItem[] children = item.getItems();
                    if (items.length <= 0) continue;
                    canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                }
                return canceled;
            }
        };
    }

    protected void updateToolbar(boolean visible) {
        if (this.clearButtonControl != null) {
            this.clearButtonControl.setVisible(visible);
        }
    }

    protected void createFilterText(Composite parent) {
        this.filterText = this.doCreateFilterText(parent);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilteredTree.this.filterText.getText();
                e.result = filterTextString.length() == 0 || filterTextString.equals(FilteredTree.this.initialText) ? FilteredTree.this.initialText : NLS.bind((String)ViewerMessages.FilteredTree_AccessibleListenerFiltered, (Object[])new String[]{filterTextString, String.valueOf(this.getFilteredItemsCount())});
            }

            private int getFilteredItemsCount() {
                TreeItem[] items;
                int total = 0;
                for (TreeItem item : items = FilteredTree.this.getViewer().getTree().getItems()) {
                    total += this.itemCount(item);
                }
                return total;
            }

            private int itemCount(TreeItem treeItem) {
                TreeItem[] children;
                int count = 1;
                for (TreeItem element : children = treeItem.getItems()) {
                    count += this.itemCount(element);
                }
                return count;
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (FilteredTree.this.filterText.getText().equals(FilteredTree.this.initialText)) {
                    FilteredTree.this.setFilterText("");
                    FilteredTree.this.textChanged();
                }
            }
        });
        this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (FilteredTree.this.filterText.getText().equals(FilteredTree.this.initialText)) {
                    FilteredTree.this.setFilterText("");
                    FilteredTree.this.textChanged();
                }
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = FilteredTree.this.getViewer().getTree().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    FilteredTree.this.treeViewer.getTree().setFocus();
                    return;
                }
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (FilteredTree.this.getViewer().getTree().getItemCount() == 0) {
                        Display.getCurrent().beep();
                    } else {
                        Tree tree;
                        TreeItem item;
                        boolean textChanged;
                        boolean hasFocus = FilteredTree.this.getViewer().getTree().setFocus();
                        boolean bl = textChanged = !FilteredTree.this.getInitialText().equals(FilteredTree.this.filterText.getText().trim());
                        if (hasFocus && textChanged && FilteredTree.this.filterText.getText().trim().length() > 0 && (item = (tree = FilteredTree.this.getViewer().getTree()).getSelectionCount() > 0 ? FilteredTree.this.getFirstMatchingItem(tree.getSelection()) : FilteredTree.this.getFirstMatchingItem(tree.getItems())) != null) {
                            tree.setSelection(new TreeItem[]{item});
                            ISelection sel = FilteredTree.this.getViewer().getSelection();
                            FilteredTree.this.getViewer().setSelection(sel, true);
                        }
                    }
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteredTree.this.textChanged();
            }
        });
        if ((this.filterText.getStyle() & 0x100) != 0) {
            this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (e.detail == 256) {
                        FilteredTree.this.clearText();
                    }
                }
            });
        }
        GridData gridData = new GridData(4, 0x1000000, true, false);
        if ((this.filterText.getStyle() & 0x100) != 0) {
            gridData.horizontalSpan = 2;
        }
        this.filterText.setLayoutData((Object)gridData);
    }

    protected Text doCreateFilterText(Composite parent) {
        if (FilteredTree.useNativeSearchField(parent)) {
            return new Text(parent, 2436);
        }
        return new Text(parent, 4);
    }

    protected void textChanged() {
        this.narrowingDown = this.previousFilterText == null || this.previousFilterText.equals(ViewerMessages.FilteredTree_FilterMessage) || this.getFilterString().startsWith(this.previousFilterText);
        this.previousFilterText = this.getFilterString();
        this.refreshJob.cancel();
        this.refreshJob.schedule(this.getRefreshJobDelay());
    }

    protected long getRefreshJobDelay() {
        return 200L;
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.filterComposite != null && FilteredTree.useNativeSearchField(this.filterComposite)) {
            this.filterComposite.setBackground(background);
        }
    }

    private void createClearText(Composite parent) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            final Label clearButton = new Label(parent, 0);
            LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)clearButton);
            final Image inactiveImage = resourceManager.createImage(JFaceResources.getImageRegistry().getDescriptor(DISABLED_CLEAR_ICON));
            final Image activeImage = resourceManager.createImage(JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON));
            final Image pressedImage = resourceManager.createImage(JFaceResources.getImageRegistry().getDescriptor(PRESSED_CLEAR_ICON));
            clearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            clearButton.setImage(inactiveImage);
            clearButton.setBackground(parent.getDisplay().getSystemColor(25));
            clearButton.setToolTipText(ViewerMessages.FilteredTree_ClearToolTip);
            clearButton.addMouseListener((MouseListener)new MouseAdapter(){
                private MouseMoveListener fMoveListener;

                public void mouseDown(MouseEvent e) {
                    clearButton.setImage(pressedImage);
                    this.fMoveListener = new MouseMoveListener(){
                        private boolean fMouseInButton = true;

                        public void mouseMove(MouseEvent e) {
                            boolean mouseInButton = this.isMouseInButton(e);
                            if (mouseInButton != this.fMouseInButton) {
                                this.fMouseInButton = mouseInButton;
                                clearButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                            }
                        }
                    };
                    clearButton.addMouseMoveListener(this.fMoveListener);
                }

                public void mouseUp(MouseEvent e) {
                    if (this.fMoveListener != null) {
                        clearButton.removeMouseMoveListener(this.fMoveListener);
                        this.fMoveListener = null;
                        boolean mouseInButton = this.isMouseInButton(e);
                        clearButton.setImage(mouseInButton ? activeImage : inactiveImage);
                        if (mouseInButton) {
                            FilteredTree.this.clearText();
                            FilteredTree.this.filterText.setFocus();
                        }
                    }
                }

                private boolean isMouseInButton(MouseEvent e) {
                    Point buttonSize = clearButton.getSize();
                    return 0 <= e.x && e.x < buttonSize.x && 0 <= e.y && e.y < buttonSize.y;
                }
            });
            clearButton.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    clearButton.setImage(activeImage);
                }

                public void mouseExit(MouseEvent e) {
                    clearButton.setImage(inactiveImage);
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            clearButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = ViewerMessages.FilteredTree_AccessibleListenerClearButton;
                }
            });
            clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
            this.clearButtonControl = clearButton;
        }
    }

    protected void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    protected void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    public final PatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public Text getFilterControl() {
        return this.filterText;
    }

    protected String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    public void setInitialText(String text) {
        this.initialText = text;
        if (this.filterText != null) {
            this.filterText.setMessage(text);
            if (this.filterText.isFocusControl()) {
                this.setFilterText(this.initialText);
                this.textChanged();
            } else {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!FilteredTree.this.filterText.isDisposed() && FilteredTree.this.filterText.isFocusControl()) {
                            FilteredTree.this.setFilterText(FilteredTree.this.initialText);
                            FilteredTree.this.textChanged();
                        }
                    }
                });
            }
        } else {
            this.setFilterText(this.initialText);
            this.textChanged();
        }
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    protected String getInitialText() {
        return this.initialText;
    }

    public static Font getBoldFont(Object element, FilteredTree tree, PatternFilter filter) {
        String filterText = tree.getFilterString();
        if (filterText == null) {
            return null;
        }
        String initialText = tree.getInitialText();
        if (!filterText.equals("") && !filterText.equals(initialText)) {
            if (tree.getPatternFilter() != filter) {
                boolean initial;
                boolean bl = initial = initialText != null && initialText.equals(filterText);
                if (initial) {
                    filter.setPattern(null);
                } else if (filterText != null) {
                    filter.setPattern(filterText);
                }
            }
            if (filter.isElementVisible((Viewer)tree.getViewer(), element) && filter.isLeafMatch((Viewer)tree.getViewer(), element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
        }
        return null;
    }

    public boolean isShowFilterControls() {
        return this.showFilterControls;
    }

    public void setShowFilterControls(boolean showFilterControls) {
        if (this.isShowFilterControls() == showFilterControls) {
            return;
        }
        this.showFilterControls = showFilterControls;
        if (this.filterComposite != null) {
            Object filterCompositeLayoutData = this.filterComposite.getLayoutData();
            if (filterCompositeLayoutData instanceof GridData) {
                ((GridData)filterCompositeLayoutData).exclude = !this.isShowFilterControls();
            } else if (filterCompositeLayoutData instanceof RowData) {
                ((RowData)filterCompositeLayoutData).exclude = !this.isShowFilterControls();
            }
            this.filterComposite.setVisible(this.isShowFilterControls());
            this.layout();
        }
    }

    static {
        Path disabledPath;
        URL disabledURL;
        ImageDescriptor disabledDesc;
        Path enabledPath;
        Bundle bundle = FrameworkUtil.getBundle(FilteredTree.class);
        URL enabledURL = FileLocator.find((Bundle)bundle, (IPath)(enabledPath = new Path("$nl$/icons/full/etool16/clear_co.png")), null);
        ImageDescriptor enabledDesc = ImageDescriptor.createFromURL((URL)enabledURL);
        if (enabledDesc != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, enabledDesc);
            JFaceResources.getImageRegistry().put(PRESSED_CLEAR_ICON, ImageDescriptor.createWithFlags((ImageDescriptor)enabledDesc, (int)2));
        }
        if ((disabledDesc = ImageDescriptor.createFromURL((URL)(disabledURL = FileLocator.find((Bundle)bundle, (IPath)(disabledPath = new Path("$nl$/icons/full/dtool16/clear_co.png")), null)))) != null) {
            JFaceResources.getImageRegistry().put(DISABLED_CLEAR_ICON, disabledDesc);
        }
    }

    class NotifyingTreeViewer
    extends TreeViewer {
        public NotifyingTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void add(Object parentElementOrTreePath, Object childElement) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElement);
        }

        public void add(Object parentElementOrTreePath, Object[] childElements) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElements);
        }

        protected void inputChanged(Object input, Object oldInput) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.inputChanged(input, oldInput);
        }

        public void insert(Object parentElementOrTreePath, Object element, int position) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.insert(parentElementOrTreePath, element, position);
        }

        public void refresh() {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh();
        }

        public void refresh(boolean updateLabels) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(updateLabels);
        }

        public void refresh(Object element) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(element);
        }

        public void refresh(Object element, boolean updateLabels) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(element, updateLabels);
        }

        public void remove(Object elementsOrTreePaths) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void remove(Object parent, Object[] elements) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(parent, elements);
        }

        public void remove(Object[] elementsOrTreePaths) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void replace(Object parentElementOrTreePath, int index, Object element) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.replace(parentElementOrTreePath, index, element);
        }

        public void setChildCount(Object elementOrTreePath, int count) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setChildCount(elementOrTreePath, count);
        }

        public void setContentProvider(IContentProvider provider) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setContentProvider(provider);
        }

        public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setHasChildren(elementOrTreePath, hasChildren);
        }
    }
}

