/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvArgumentsProvider;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.provider.CsvReaderFactory;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvReader;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvRecord;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;

class CsvFileArgumentsProvider
extends AnnotationBasedArgumentsProvider<CsvFileSource> {
    private final InputStreamProvider inputStreamProvider;

    CsvFileArgumentsProvider() {
        this(DefaultInputStreamProvider.INSTANCE);
    }

    CsvFileArgumentsProvider(InputStreamProvider inputStreamProvider) {
        this.inputStreamProvider = inputStreamProvider;
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context, CsvFileSource csvFileSource) {
        Charset charset = CsvFileArgumentsProvider.getCharsetFrom(csvFileSource);
        CsvReaderFactory.validate(csvFileSource);
        Stream<Source> resources = Arrays.stream(csvFileSource.resources()).map(this.inputStreamProvider::classpathResource);
        Stream<Source> files = Arrays.stream(csvFileSource.files()).map(this.inputStreamProvider::file);
        List<Source> sources = Stream.concat(resources, files).toList();
        return ((List)Preconditions.notEmpty(sources, (String)"Resources or files must not be empty")).stream().map(source -> source.open(context)).map(inputStream -> CsvReaderFactory.createReaderFor(csvFileSource, inputStream, charset)).flatMap(reader -> CsvFileArgumentsProvider.toStream(reader, csvFileSource));
    }

    private static Charset getCharsetFrom(CsvFileSource csvFileSource) {
        try {
            return Charset.forName(csvFileSource.encoding());
        }
        catch (Exception ex) {
            throw new PreconditionViolationException("The charset supplied in " + String.valueOf(csvFileSource) + " is invalid", (Throwable)ex);
        }
    }

    private static Stream<Arguments> toStream(CsvReader<? extends CsvRecord> reader, CsvFileSource csvFileSource) {
        CsvExceptionHandlingSpliterator<? extends CsvRecord> spliterator = CsvExceptionHandlingSpliterator.delegatingTo(reader.spliterator(), csvFileSource);
        boolean useHeadersInDisplayName = csvFileSource.useHeadersInDisplayName();
        return (Stream)StreamSupport.stream(spliterator, false).skip(csvFileSource.numLinesToSkip()).map(record -> CsvArgumentsProvider.processCsvRecord(record, useHeadersInDisplayName)).onClose(() -> {
            try {
                reader.close();
            }
            catch (Throwable throwable) {
                throw CsvArgumentsProvider.handleCsvException(throwable, csvFileSource);
            }
        });
    }

    private static class DefaultInputStreamProvider
    implements InputStreamProvider {
        private static final DefaultInputStreamProvider INSTANCE = new DefaultInputStreamProvider();

        private DefaultInputStreamProvider() {
        }

        @Override
        public InputStream openClasspathResource(Class<?> baseClass, String path) {
            Preconditions.notBlank((String)path, () -> "Classpath resource [" + path + "] must not be null or blank");
            InputStream inputStream = baseClass.getResourceAsStream(path);
            return (InputStream)Preconditions.notNull((Object)inputStream, () -> "Classpath resource [" + path + "] does not exist");
        }

        @Override
        public InputStream openFile(String path) {
            Preconditions.notBlank((String)path, () -> "File [" + path + "] must not be null or blank");
            try {
                return Files.newInputStream(Path.of(path, new String[0]), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new JUnitException("File [" + path + "] could not be read", (Throwable)e);
            }
        }
    }

    static interface InputStreamProvider {
        public InputStream openClasspathResource(Class<?> var1, String var2);

        public InputStream openFile(String var1);

        default public Source classpathResource(String path) {
            return context -> this.openClasspathResource(context.getRequiredTestClass(), path);
        }

        default public Source file(String path) {
            return __ -> this.openFile(path);
        }
    }

    private record CsvExceptionHandlingSpliterator<T>(Spliterator<T> delegate, CsvFileSource csvFileSource) implements Spliterator<T>
    {
        static <T> CsvExceptionHandlingSpliterator<T> delegatingTo(Spliterator<T> delegate, CsvFileSource csvFileSource) {
            return new CsvExceptionHandlingSpliterator<T>(delegate, csvFileSource);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            try {
                return this.delegate.tryAdvance(action);
            }
            catch (Throwable throwable) {
                throw CsvArgumentsProvider.handleCsvException(throwable, this.csvFileSource);
            }
        }

        @Override
        public Spliterator<T> trySplit() {
            return this.delegate.trySplit();
        }

        @Override
        public long estimateSize() {
            return this.delegate.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.delegate.characteristics();
        }
    }

    @FunctionalInterface
    static interface Source {
        public InputStream open(ExtensionContext var1);
    }
}

