/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.pdf;

import java.io.IOException;
import org.openpdf.text.DocumentException;
import org.openpdf.text.Image;
import org.openpdf.text.error_messages.MessageLocalization;
import org.openpdf.text.pdf.BaseFont;
import org.openpdf.text.pdf.PdfContentByte;
import org.openpdf.text.pdf.PdfObject;
import org.openpdf.text.pdf.PdfReaderInstance;
import org.openpdf.text.pdf.PdfSpotColor;
import org.openpdf.text.pdf.PdfStream;
import org.openpdf.text.pdf.PdfTemplate;
import org.openpdf.text.pdf.PdfTransparencyGroup;
import org.openpdf.text.pdf.PdfWriter;

public class PdfImportedPage
extends PdfTemplate {
    PdfReaderInstance readerInstance;
    int pageNumber;

    PdfImportedPage(PdfReaderInstance readerInstance, PdfWriter writer, int pageNumber) {
        this.readerInstance = readerInstance;
        this.pageNumber = pageNumber;
        this.writer = writer;
        this.bBox = readerInstance.getReader().getPageSize(pageNumber);
        this.setMatrix(1.0f, 0.0f, 0.0f, 1.0f, -this.bBox.getLeft(), -this.bBox.getBottom());
        this.type = 2;
    }

    public PdfImportedPage getFromReader() {
        return this;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public void addImage(Image image, float a, float b, float c, float d, float e, float f) throws DocumentException {
        this.throwError();
    }

    @Override
    public void addTemplate(PdfTemplate template, float a, float b, float c, float d, float e, float f) {
        this.throwError();
    }

    @Override
    public PdfContentByte getDuplicate() {
        this.throwError();
        return null;
    }

    @Override
    PdfStream getFormXObject(int compressionLevel) throws IOException {
        return this.readerInstance.getFormXObject(this.pageNumber, compressionLevel);
    }

    @Override
    public void setColorFill(PdfSpotColor sp, float tint) {
        this.throwError();
    }

    @Override
    public void setColorStroke(PdfSpotColor sp, float tint) {
        this.throwError();
    }

    @Override
    PdfObject getResources() {
        return this.readerInstance.getResources(this.pageNumber);
    }

    @Override
    public void setFontAndSize(BaseFont bf, float size) {
        this.throwError();
    }

    @Override
    public void setGroup(PdfTransparencyGroup group) {
        this.throwError();
    }

    void throwError() {
        throw new RuntimeException(MessageLocalization.getComposedMessage("content.can.not.be.added.to.a.pdfimportedpage"));
    }

    PdfReaderInstance getPdfReaderInstance() {
        return this.readerInstance;
    }
}

