/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.BirtHashMap;
import org.eclipse.birt.core.script.CoreJavaScriptWrapper;
import org.eclipse.birt.core.script.IJavascriptWrapper;
import org.eclipse.birt.core.script.NativeJavaLinkedHashMap;
import org.eclipse.birt.core.script.NativeJavaList;
import org.eclipse.birt.core.script.NativeJavaMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;

public class CoreJavaScriptWrapperTest
extends TestCase {
    Context cx;
    Scriptable scope;
    IJavascriptWrapper coreWrapper;

    @Before
    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        this.coreWrapper = new CoreJavaScriptWrapper();
    }

    @After
    public void tearDown() {
        Context.exit();
    }

    @Test
    public void testWrap() {
        NativeArray nativeArray = new NativeArray(new Object[]{"one", "two"});
        Object object = this.coreWrapper.wrap(this.cx, this.scope, (Object)nativeArray, null);
        CoreJavaScriptWrapperTest.assertTrue((boolean)(object instanceof NativeArray));
        ArrayList list = new ArrayList();
        object = this.coreWrapper.wrap(this.cx, this.scope, list, null);
        CoreJavaScriptWrapperTest.assertTrue((boolean)(object instanceof NativeJavaList));
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        object = this.coreWrapper.wrap(this.cx, this.scope, linkedHashMap, null);
        CoreJavaScriptWrapperTest.assertTrue((boolean)(object instanceof NativeJavaLinkedHashMap));
        BirtHashMap birtHashMap = new BirtHashMap();
        object = this.coreWrapper.wrap(this.cx, this.scope, (Object)birtHashMap, null);
        CoreJavaScriptWrapperTest.assertTrue((boolean)(object instanceof NativeJavaMap));
    }
}

