/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;

public class ParameterValidationTest
extends EngineCase {
    protected HashMap supportedMap = null;
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/param.rptdesign";
    static final String REPORT_DESIGN = "ReportEngineTest.rptdesign";

    public void setUp() {
        this.removeFile(REPORT_DESIGN);
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
    }

    public void testParameterValidation() {
        try {
            this.engine = this.createReportEngine();
            IReportRunnable runnable = this.engine.openReportDesign(REPORT_DESIGN);
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
            HTMLRenderOption options = new HTMLRenderOption();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            options.setOutputStream((OutputStream)out);
            options.setOutputFormat("html");
            options.setHtmlPagination(true);
            task.setRenderOption((IRenderOption)options);
            task.setParameterValue("p1", (Object)"bbb");
            ParameterValidationTest.assertTrue((!task.validateParameters() ? 1 : 0) != 0);
            ParameterValidationTest.assertEquals((int)task.getErrors().size(), (int)1);
            task.setParameterValue("p1", (Object)2);
            ParameterValidationTest.assertTrue((boolean)task.validateParameters());
            ParameterValidationTest.assertEquals((int)task.getErrors().size(), (int)0);
            task.run();
            task.close();
            this.engine.destroy();
            this.engine = null;
        }
        catch (EngineException ex) {
            ex.printStackTrace();
        }
    }

    public void tearDown() {
        this.removeFile(REPORT_DESIGN);
    }
}

