/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.util.ArrayList;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefn;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;

public class GetParameterGroupDefnTest
extends EngineCase {
    protected IReportEngine engine = null;
    protected IReportRunnable runnable = null;
    protected IGetParameterDefinitionTask paramGroupTask = null;
    protected IScalarParameterDefn scalarParam = null;
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/GetParameterGroupDefnTest.rptdesign";
    static final String REPORT_DESIGN = "GetParameterGroupDefnTest.rptdesign";

    public void setUp() throws Exception {
        this.removeFile(REPORT_DESIGN);
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        this.engine = this.createReportEngine();
        this.runnable = this.engine.openReportDesign(REPORT_DESIGN);
        this.paramGroupTask = this.engine.createGetParameterDefinitionTask(this.runnable);
    }

    public void tearDown() {
        if (this.engine != null) {
            this.engine.shutdown();
        }
        this.removeFile(REPORT_DESIGN);
    }

    public void testGetParameterOutofGroup() {
        IScalarParameterDefn paramDefn = (IScalarParameterDefn)this.paramGroupTask.getParameterDefn("paramStringOutofGroup");
        assert ("outof".equals(paramDefn.getDefaultValue()));
    }

    public void testGetGroupByName() {
        String PARAM_GROUP_NAME = "paramGroup";
        String PARAM_GROUP_DISP_NAME = "paramGroupDispName";
        int PARAM_COUNT_IN_GROUP = 11;
        IParameterGroupDefn paramGroupDefn = (IParameterGroupDefn)this.paramGroupTask.getParameterDefn("paramGroup");
        GetParameterGroupDefnTest.assertTrue((paramGroupDefn != null ? 1 : 0) != 0);
        GetParameterGroupDefnTest.assertTrue((boolean)"paramGroup".equals(paramGroupDefn.getName()));
        GetParameterGroupDefnTest.assertTrue((boolean)"paramGroupDispName".equals(paramGroupDefn.getDisplayName()));
        ArrayList parameters = paramGroupDefn.getContents();
        GetParameterGroupDefnTest.assertTrue((11 == parameters.size() ? 1 : 0) != 0);
        IParameterDefnBase param = null;
        String[] goldenParamNames = new String[]{"paramString", "paramInteger", "paramFloat", "paramDecimal", "paramDateTime", "paramBoolean", "paramStringListBoxStatic", "paramComboBoxStatic", "paramRadioButtonStatic", "paramStringListBoxDynamic", "paramStringComboBoxDynamic"};
        GetParameterGroupDefnTest.assertTrue((11 == goldenParamNames.length ? 1 : 0) != 0);
        int size = parameters.size();
        int index = 0;
        while (index < size) {
            param = (IParameterDefnBase)parameters.get(index);
            GetParameterGroupDefnTest.assertTrue((boolean)goldenParamNames[index].equals(param.getName()));
            ++index;
        }
    }

    public void testGetParameterDirectlyByName() {
        String PARAMETER_NAME = "paramString";
        IParameterDefn paramDefn = (IParameterDefn)this.paramGroupTask.getParameterDefn("paramString");
        GetParameterGroupDefnTest.assertTrue((paramDefn != null ? 1 : 0) != 0);
    }
}

