/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.CachedImage;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLImageHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.engine.api.script.IReportContext;

public class CachedImageHandlerTest
extends EngineCase {
    static final String DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/cached-image-handler.rptdesign";
    static final String REPORT_DESIGN = "./utest/test.rptdesign";
    static final String REPORT_DOCUMENT = "./utest/test.rptdocument";
    static final String TEST_FOLDER = "./utest/";

    public void setUp() {
        this.removeFile(TEST_FOLDER);
        this.copyResource(DESIGN_RESOURCE, REPORT_DESIGN);
    }

    public void tearDown() {
        this.removeFile(TEST_FOLDER);
    }

    public void testRender() throws Exception {
        CachedImageHandler imageHandler = new CachedImageHandler();
        EngineConfig config = new EngineConfig();
        RenderOption option = new RenderOption();
        option.setImageHandler((IHTMLImageHandler)imageHandler);
        config.setEmitterConfiguration("html", (Object)option);
        ReportEngine engine = new ReportEngine(config);
        IReportRunnable report = engine.openReportDesign(REPORT_DESIGN);
        IRunTask task = engine.createRunTask(report);
        task.run(REPORT_DOCUMENT);
        task.close();
        IReportDocument document = engine.openReportDocument(REPORT_DOCUMENT);
        IRenderTask render = engine.createRenderTask(document);
        HTMLRenderOption options = new HTMLRenderOption();
        options.setOutputFormat("html");
        options.setOutputStream((OutputStream)new ByteArrayOutputStream());
        render.setRenderOption((IRenderOption)options);
        render.render();
        render.close();
        CachedImageHandlerTest.assertEquals((int)1, (int)imageHandler.cachedImageCount);
        CachedImageHandlerTest.assertEquals((int)0, (int)imageHandler.customImageCount);
        CachedImageHandlerTest.assertEquals((int)1, (int)imageHandler.fileImageCount);
        render = engine.createRenderTask(document);
        render.setRenderOption((IRenderOption)options);
        render.render();
        render.close();
        CachedImageHandlerTest.assertEquals((int)1, (int)imageHandler.cachedImageCount);
        CachedImageHandlerTest.assertEquals((int)0, (int)imageHandler.customImageCount);
        CachedImageHandlerTest.assertEquals((int)2, (int)imageHandler.fileImageCount);
        document.close();
        engine.destroy();
    }

    class CachedImageHandler
    extends HTMLImageHandler {
        int cachedImageCount = 0;
        int customImageCount = 0;
        int fileImageCount = 0;
        HashMap map = new HashMap();

        CachedImageHandler() {
        }

        public CachedImage getCachedImage(String id, int sourceType, IReportContext context) {
            String url = (String)this.map.get(id);
            if (url != null) {
                return new CachedImage(id, url);
            }
            return null;
        }

        public CachedImage addCachedImage(String id, int sourceType, IImage image, IReportContext context) {
            ++this.cachedImageCount;
            String url = "CACHED_IMAGE:" + this.cachedImageCount;
            this.map.put(id, url);
            CachedImage cache = new CachedImage(id, url);
            return cache;
        }

        public String onCustomImage(IImage image, IReportContext context) {
            ++this.customImageCount;
            return "CUSTOM_IMAGE:" + this.customImageCount;
        }

        public String onFileImage(IImage image, IReportContext context) {
            ++this.fileImageCount;
            return image.getID();
        }
    }
}

