/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.InconsistentColumnsValidator;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.validators.ValidatorTestCase;

public class InconsistentColumnsValidatorTest
extends ValidatorTestCase {
    ValidatorTestCase.MyListener listener = new ValidatorTestCase.MyListener(this);

    public void testTriggers() throws Exception {
        this.createDesign();
        MetaDataDictionary.getInstance().setUseValidationTrigger(true);
        TableHandle tableHandle = this.designHandle.getElementFactory().newTableItem("table1");
        this.designHandle.addValidationListener((IValidationListener)this.listener);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        ColumnHandle columnHandle1 = tableHandle.getElementFactory().newTableColumn();
        ColumnHandle columnHandle2 = tableHandle.getElementFactory().newTableColumn();
        ColumnHandle columnHandle3 = tableHandle.getElementFactory().newTableColumn();
        ColumnHandle columnHandle4 = tableHandle.getElementFactory().newTableColumn();
        tableHandle.getColumns().add((DesignElementHandle)columnHandle1);
        InconsistentColumnsValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)tableHandle, InconsistentColumnsValidator.getInstance().getName(), "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT"));
        tableHandle.getColumns().add((DesignElementHandle)columnHandle2);
        InconsistentColumnsValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)tableHandle, InconsistentColumnsValidator.getInstance().getName(), "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT"));
        tableHandle.getColumns().add((DesignElementHandle)columnHandle3);
        InconsistentColumnsValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)tableHandle, InconsistentColumnsValidator.getInstance().getName(), "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT"));
        RowHandle rowHandle1 = tableHandle.getElementFactory().newTableRow(2);
        RowHandle rowHandle2 = tableHandle.getElementFactory().newTableRow(3);
        RowHandle rowHandle3 = tableHandle.getElementFactory().newTableRow(4);
        tableHandle.getHeader().add((DesignElementHandle)rowHandle1);
        InconsistentColumnsValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)tableHandle, InconsistentColumnsValidator.getInstance().getName(), "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT"));
        tableHandle.getDetail().add((DesignElementHandle)rowHandle2);
        InconsistentColumnsValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)tableHandle, InconsistentColumnsValidator.getInstance().getName(), "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT"));
        tableHandle.getFooter().add((DesignElementHandle)rowHandle3);
        InconsistentColumnsValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)tableHandle, InconsistentColumnsValidator.getInstance().getName(), "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT"));
        tableHandle.getColumns().add((DesignElementHandle)columnHandle4);
        InconsistentColumnsValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)tableHandle, InconsistentColumnsValidator.getInstance().getName(), "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT"));
        columnHandle2.dropAndClear();
        InconsistentColumnsValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)tableHandle, InconsistentColumnsValidator.getInstance().getName(), "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT"));
    }
}

