/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class OdaDataSourceParseTest
extends BaseTestCase {
    String fileName = "OdaDataSourceParseTest.xml";
    String outFileName = "OdaDataSourceParseTest_out.xml";
    String goldenFileName = "OdaDataSourceParseTest_golden.xml";
    String semanticCheckFileName = "OdaDataSourceParseTest_1.xml";
    private String unknowOdafileName = "OdaDataSourceParseTest_2.xml";

    public void testParser() throws Exception {
        OdaDataSourceHandle dataSourceHandle = this.getDataSource("myDataSource");
        OdaDataSourceParseTest.assertEquals((String)"script_beforeopen", (String)dataSourceHandle.getBeforeOpen());
        OdaDataSourceParseTest.assertEquals((String)"script_beforeclose", (String)dataSourceHandle.getBeforeClose());
        OdaDataSourceParseTest.assertEquals((String)"script_afteropen", (String)dataSourceHandle.getAfterOpen());
        OdaDataSourceParseTest.assertEquals((String)"script_afterclose", (String)dataSourceHandle.getAfterClose());
        dataSourceHandle = this.getDataSource("myDataSource1");
        OdaDataSourceParseTest.assertEquals((String)"Driver Class", (String)dataSourceHandle.getStringProperty("odaDriverClass"));
        OdaDataSourceParseTest.assertEquals((String)"URL", (String)dataSourceHandle.getStringProperty("odaURL"));
        OdaDataSourceParseTest.assertEquals((String)"User", (String)dataSourceHandle.getStringProperty("odaUser"));
        OdaDataSourceParseTest.assertEquals((String)"New Password", (String)dataSourceHandle.getStringProperty("odaPassword"));
        OdaDataSourceParseTest.assertEquals((String)"1.1", (String)dataSourceHandle.getDesigerStateVersion());
        OdaDataSourceParseTest.assertEquals((String)"content as string", (String)dataSourceHandle.getDesigerStateContentAsString());
        OdaDataSourceParseTest.assertEquals((String)"content as blob", (String)new String(dataSourceHandle.getDesigerStateContentAsBlob(), "8859_1"));
    }

    public void testWriter() throws Exception {
        OdaDataSourceHandle dataSourceHandle = this.getDataSource("myDataSource1");
        dataSourceHandle.setBeforeOpen("My before open");
        dataSourceHandle.setBeforeClose("My before close");
        dataSourceHandle.setAfterOpen("My after open");
        dataSourceHandle.setAfterClose("My after close");
        dataSourceHandle.setProperty("odaDriverClass", (Object)"New Driver Class");
        dataSourceHandle.setProperty("odaURL", (Object)"New URL");
        dataSourceHandle.setProperty("odaUser", (Object)"New User");
        dataSourceHandle.setProperty("odaPassword", (Object)"New Password");
        dataSourceHandle.setDesigerStateVersion("2.1");
        dataSourceHandle.setDesigerStateContentAsString("new content as string");
        String strBlob = "new content as blob";
        dataSourceHandle.setDesigerStateContentAsBlob(strBlob.getBytes("8859_1"));
        this.save();
        OdaDataSourceParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testUnknowOdaParser() throws Exception {
        this.openDesign(this.unknowOdafileName);
        this.save();
        OdaDataSourceParseTest.assertTrue((boolean)this.compareFile("OdaDataSourceParseTest_golden_2.xml"));
    }

    public void testSemanticCheck() throws Exception {
        this.openDesign(this.semanticCheckFileName);
        OdaDataSourceParseTest.assertEquals((int)2, (int)this.design.getErrorList().size());
        ErrorDetail error = (ErrorDetail)this.design.getErrorList().get(0);
        OdaDataSourceParseTest.assertEquals((String)"Error.SemanticError.INVALID_MANIFEST", (String)error.getErrorCode());
    }

    private OdaDataSourceHandle getDataSource(String name) throws Exception {
        this.openDesign(this.fileName);
        OdaDataSourceHandle dataSource = (OdaDataSourceHandle)this.designHandle.findDataSource(name);
        OdaDataSourceParseTest.assertNotNull((Object)dataSource);
        return dataSource;
    }

    @Override
    protected void tearDown() throws Exception {
        MetaDataDictionary.reset();
        engine = null;
        super.tearDown();
    }
}

