/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import junit.framework.TestCase;
import org.eclipse.birt.report.model.css.property.ParseException;
import org.eclipse.birt.report.model.css.property.PropertyParser;

public class CssParserTest
extends TestCase {
    public void testBackground() throws Exception {
        String style = "url(\"chess.png\") gray 50% repeat fixed ";
        PropertyParser parser = new PropertyParser((Reader)new StringReader(style));
        parser.parseBackground();
        LinkedHashMap result = parser.getCssProperties();
        CssParserTest.assertEquals(((HashMap)result).get("background-image"), (Object)"url(\"chess.png\")");
        CssParserTest.assertEquals(((HashMap)result).get("background-color"), (Object)"gray");
        CssParserTest.assertEquals(((HashMap)result).get("background-position"), (Object)"50%");
        CssParserTest.assertEquals(((HashMap)result).get("background-repeat"), (Object)"repeat");
        CssParserTest.assertEquals(((HashMap)result).get("background-attachment"), (Object)"fixed");
        style = "#ccc";
        parser.ReInit((Reader)new StringReader(style));
        parser.parseBackground();
        result = parser.getCssProperties();
        CssParserTest.assertEquals((Object)"#ccc", ((HashMap)result).get("background-color"));
    }

    public void testFont() throws Exception {
        String style = "12px/14px sans-serif ";
        PropertyParser parser = new PropertyParser((Reader)new StringReader(style));
        parser.parseFont();
        LinkedHashMap result = parser.getCssProperties();
        CssParserTest.assertEquals(((HashMap)result).get("font-size"), (Object)"12px");
        CssParserTest.assertEquals(((HashMap)result).get("line-height"), (Object)"14px");
        CssParserTest.assertEquals(((HashMap)result).get("font-family"), (Object)"sans-serif");
        parser.ReInit((Reader)new StringReader(" 80% sans-serif "));
        parser.parseFont();
        result = parser.getCssProperties();
        CssParserTest.assertEquals(((HashMap)result).get("font-size"), (Object)"80%");
        CssParserTest.assertEquals(((HashMap)result).get("font-family"), (Object)"sans-serif");
        parser.ReInit((Reader)new StringReader(" x-large/110% \"New Century Schoolbook\", serif "));
        parser.parseFont();
        result = parser.getCssProperties();
        CssParserTest.assertEquals(((HashMap)result).get("font-size"), (Object)"x-large");
        CssParserTest.assertEquals(((HashMap)result).get("line-height"), (Object)"110%");
        CssParserTest.assertEquals(((HashMap)result).get("font-family"), (Object)"\"New Century Schoolbook\",serif");
        parser.ReInit((Reader)new StringReader(" bold italic large Palatino, serif "));
        parser.parseFont();
        result = parser.getCssProperties();
        CssParserTest.assertEquals(((HashMap)result).get("font-weight"), (Object)"bold");
        CssParserTest.assertEquals(((HashMap)result).get("font-style"), (Object)"italic");
        CssParserTest.assertEquals(((HashMap)result).get("font-size"), (Object)"large");
        CssParserTest.assertEquals(((HashMap)result).get("font-family"), (Object)"Palatino,serif");
        parser.ReInit((Reader)new StringReader(" normal small-caps 120%/120% fantasy "));
        parser.parseFont();
        result = parser.getCssProperties();
        CssParserTest.assertEquals(((HashMap)result).get("font-weight"), (Object)"normal");
        CssParserTest.assertEquals(((HashMap)result).get("font-style"), (Object)"normal");
        CssParserTest.assertEquals(((HashMap)result).get("font-variant"), (Object)"small-caps");
        CssParserTest.assertEquals(((HashMap)result).get("font-size"), (Object)"120%");
        CssParserTest.assertEquals(((HashMap)result).get("line-height"), (Object)"120%");
        CssParserTest.assertEquals(((HashMap)result).get("font-family"), (Object)"fantasy");
    }

    public void testBorderWidth() throws Exception {
        String style = "medium thin";
        PropertyParser parser = new PropertyParser((Reader)new StringReader(style));
        parser.parseBorderWidth();
        LinkedHashMap result = parser.getCssProperties();
        CssParserTest.assertEquals(((HashMap)result).get("border-top-width"), (Object)"medium");
        CssParserTest.assertEquals(((HashMap)result).get("border-right-width"), (Object)"thin");
        CssParserTest.assertEquals(((HashMap)result).get("border-bottom-width"), (Object)"medium");
        CssParserTest.assertEquals(((HashMap)result).get("border-left-width"), (Object)"thin");
        style = "1em";
        parser.ReInit((Reader)new StringReader(style));
        parser.parsePadding();
        result = parser.getCssProperties();
        CssParserTest.assertEquals(((HashMap)result).get("padding-top"), (Object)"1em");
        CssParserTest.assertEquals(((HashMap)result).get("padding-right"), (Object)"1em");
        CssParserTest.assertEquals(((HashMap)result).get("padding-bottom"), (Object)"1em");
        CssParserTest.assertEquals(((HashMap)result).get("padding-left"), (Object)"1em");
    }

    public void testwithException1() throws Exception {
        try {
            String style = "1p red double";
            PropertyParser parser = new PropertyParser((Reader)new StringReader(style));
            parser.parseBorder();
            CssParserTest.fail();
        }
        catch (ParseException e) {
            CssParserTest.assertNotNull((Object)((Object)e));
        }
    }

    public void testFont1() throws Exception {
        String style = "italic small-caps  bold 2em/120% \"Bitstream Vera Sans\", Tahoma, Verdana, \"Myriad Web\", Syntax, sans-serif";
        PropertyParser parser = new PropertyParser(style);
        parser.parseFont();
        LinkedHashMap result = parser.getCssProperties();
        CssParserTest.assertEquals((Object)"\"Bitstream Vera Sans\",Tahoma,Verdana,\"Myriad Web\",Syntax,sans-serif", ((HashMap)result).get("font-family"));
    }
}

