/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;

public class HTMLListLM
extends HTMLBlockStackingLM {
    boolean isFirstLayout;

    public HTMLListLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        super.initialize(parent, content, executor, emitter);
        this.isFirstLayout = true;
    }

    protected void repeatHeader() throws BirtException {
        IListBandContent header;
        IListContent list;
        if (!this.isFirstLayout && (list = (IListContent)this.content).isHeaderRepeat() && (header = list.getHeader()) != null) {
            boolean pageBreak = this.context.allowPageBreak();
            this.context.setAllowPageBreak(pageBreak);
            IPageBuffer buffer = this.context.getPageBufferManager();
            boolean isRepeated = buffer.isRepeated();
            buffer.setRepeated(true);
            this.engine.layout((ILayoutManager)this, header, this.emitter);
            buffer.setRepeated(isRepeated);
            this.context.setAllowPageBreak(pageBreak);
        }
        this.isFirstLayout = false;
    }

    @Override
    protected boolean layoutChildren() throws BirtException {
        this.repeatHeader();
        boolean hasNext = super.layoutChildren();
        return hasNext;
    }
}

