/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import com.lowagie.text.Image;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;

public class ImageItemExecutor
extends QueryItemExecutor {
    public ImageItemExecutor(ExecutorManager manager) {
        super(manager, 1);
    }

    @Override
    public IContent execute() {
        ImageItemDesign imageDesign = (ImageItemDesign)this.getDesign();
        IImageContent imageContent = this.report.createImageContent();
        this.setContent(imageContent);
        this.executeQuery();
        this.initializeContent(imageDesign, imageContent);
        this.processAction(imageDesign, imageContent);
        this.processBookmark(imageDesign, imageContent);
        this.processStyle(imageDesign, imageContent);
        this.processVisibility(imageDesign, imageContent);
        this.processUserProperties(imageDesign, imageContent);
        try {
            this.handleImage(imageDesign, imageContent);
            this.processProportionalScale(imageDesign, imageContent);
        }
        catch (BirtException ex) {
            this.context.addException(ex);
        }
        if (this.context.isInFactory()) {
            this.handleOnCreate(imageContent);
        }
        this.startTOCEntry(imageContent);
        return imageContent;
    }

    private void processProportionalScale(ImageItemDesign imageDesign, IImageContent imageContent) {
        DimensionType width = imageDesign.getWidth();
        DimensionType height = imageDesign.getHeight();
        if (imageDesign.isProportionalScale() && width != null && height != null) {
            Image imageData = EmitterUtil.getImage(imageContent);
            String targetUnit = "px";
            if (imageData != null) {
                double iw = imageData.getWidth();
                double ih = imageData.getHeight();
                iw = iw < 0.0 ? 1.0 : iw;
                ih = ih < 0.0 ? 1.0 : ih;
                double rw = 0.0;
                double rh = 0.0;
                targetUnit = "in";
                if (width != null && width.getUnits().equalsIgnoreCase(height.getUnits())) {
                    targetUnit = width.getUnits();
                    rw = width.getMeasure();
                    rh = height.getMeasure();
                } else {
                    try {
                        rw = width.convertTo("in");
                        rh = height.convertTo("in");
                    }
                    catch (IllegalArgumentException e) {
                        rw = (double)PropertyUtil.getDimensionValue(imageContent, width) / 1000.0;
                        rh = (double)PropertyUtil.getDimensionValue(imageContent, height) / 1000.0;
                        if (rw == 0.0 || rh == 0.0) {
                            return;
                        }
                        targetUnit = "pt";
                    }
                }
                double wRatio = rw / iw;
                double hRatio = rh / ih;
                if (wRatio < hRatio) {
                    height = new DimensionType(ih * wRatio, targetUnit);
                    imageContent.setHeight(height);
                } else {
                    width = new DimensionType(iw * hRatio, targetUnit);
                    imageContent.setWidth(width);
                }
            }
        }
    }

    @Override
    public void close() throws BirtException {
        this.finishTOCEntry();
        this.closeQuery();
        super.close();
    }

    protected void handleImage(ImageItemDesign imageDesign, IImageContent imageContent) throws BirtException {
        switch (imageDesign.getImageSource()) {
            case 0: {
                Expression uriExpr = imageDesign.getImageUri();
                if (uriExpr == null) break;
                this.handleURIImage(uriExpr, imageContent);
                break;
            }
            case 3: {
                Expression fileExpr = imageDesign.getImageUri();
                assert (fileExpr != null);
                this.handleFileExpressionImage(fileExpr, imageContent);
                break;
            }
            case 1: {
                Expression imageName = imageDesign.getImageName();
                assert (imageName != null);
                this.handleNamedImage(imageName, imageContent);
                break;
            }
            case 2: {
                Expression imgExpr = imageDesign.getImageExpression();
                Expression fmtExpr = imageDesign.getImageFormat();
                assert (imgExpr != null);
                this.handleValueImage(imgExpr, fmtExpr, imageContent);
                break;
            }
            default: {
                this.getLogger().log(Level.SEVERE, "[ImageItemExecutor] invalid image source");
                this.context.addException(imageDesign.getHandle(), (BirtException)new EngineException("Error.InvalidImageSourceError"));
                assert (false);
                break;
            }
        }
    }

    protected void handleURIImage(Expression uriExpr, IImageContent imageContent) throws BirtException {
        imageContent.setImageSource(3);
        assert (uriExpr != null);
        String strUri = this.evaluateString(uriExpr);
        if (strUri == null) {
            strUri = uriExpr.getScriptText();
        }
        imageContent.setURI(strUri);
    }

    protected void handleNamedImage(Expression nameExpr, IImageContent imageContent) throws BirtException {
        EmbeddedImage embeddedImage;
        imageContent.setImageSource(1);
        imageContent.setURI(null);
        String imageName = this.evaluateString(nameExpr);
        if (imageName == null) {
            imageName = nameExpr.getScriptText();
        }
        if ((embeddedImage = this.context.getReport().getReportDesign().findImage(imageName)) != null) {
            imageContent.setData(embeddedImage.getData(this.context.getDesign().getModule()));
            String mimeType = embeddedImage.getType(this.context.getDesign().getModule());
            if (mimeType != null) {
                imageContent.setMIMEType(mimeType);
                String extension = FileUtil.getExtFromType(mimeType);
                if (extension != null) {
                    imageContent.setExtension(extension);
                }
            } else {
                String extension = FileUtil.getExtFromFileName(imageName);
                if (extension != null) {
                    imageContent.setExtension(extension);
                    mimeType = FileUtil.getTypeFromExt(extension);
                    if (mimeType != null) {
                        imageContent.setMIMEType(mimeType);
                    }
                }
            }
            imageContent.setName(imageName);
        }
    }

    protected void handleValueImage(Expression imgExpr, Expression fmtExpr, IImageContent imageContent) throws BirtException {
        byte[] imgData = null;
        String imgExt = null;
        String mimeType = null;
        imageContent.setImageSource(2);
        Object value = this.evaluate(imgExpr);
        if (value instanceof byte[]) {
            imgData = (byte[])value;
        }
        if (fmtExpr != null && (mimeType = this.evaluateString(fmtExpr)) != null) {
            imgExt = FileUtil.getExtFromType(mimeType);
        }
        if (imgData != null) {
            imageContent.setData(imgData);
            imageContent.setExtension(imgExt);
            imageContent.setURI(null);
            imageContent.setMIMEType(mimeType);
        }
    }

    protected void handleFileExpressionImage(Expression fileExpr, IImageContent imageContent) throws BirtException {
        String imageFile = this.evaluateString(fileExpr);
        if (imageFile == null) {
            imageFile = fileExpr.getScriptText();
        }
        imageContent.setURI(imageFile);
        imageContent.setImageSource(0);
        String imgExt = FileUtil.getExtFromFileName(imageFile);
        if (imgExt != null) {
            imageContent.setExtension(imgExt);
            String mimeType = FileUtil.getTypeFromExt(imgExt);
            if (mimeType != null) {
                imageContent.setMIMEType(mimeType);
            }
        }
        if (imageFile == null) {
            this.getLogger().log(Level.SEVERE, "[ImageItemExecutor] Source image file is missing");
            this.context.addException(this.design.getHandle(), (BirtException)new EngineException("Error.MissingImageFileError"));
        }
    }
}

