/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.runtime.GUIException;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceSelectionValidator;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.BirtImageLoader;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.ImageCanvas;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ColumnBindingDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImageBuilder
extends BaseDialog {
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg", ".jpeg", ".jpe", ".jfif", ".gif", ".png", ".tif", ".tiff", ".ico", ".svg"};
    private static final String[] IMAGE_FILEFILTERS = new String[]{"*.bmp;*.jpg;*.jpeg;*.jpe;*.jfif;*.gif;*.png;*.tif;*.tiff;*.ico;*.svg"};
    public static final String DLG_TITLE_NEW = Messages.getString((String)"ImageBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"ImageBuilder.DialogTitle.Edit");
    private static final String BUTTON_BROWSE_TOOLTIP = Messages.getString((String)"ImageBuilder.Button.Browser.Tooltip");
    private static final String BUTTON_IMPORT = Messages.getString((String)"ImageBuilder.Button.Import");
    private static final String BUTTON_SELECT_IMAGE_DATA = Messages.getString((String)"ImageBuilder.Button.SelectImageData");
    private static final String TYPE_URI = Messages.getString((String)"ImageBuilder.Type.URI");
    private static final String TYPE_RESOURCE_FILE = Messages.getString((String)"ImageBuilder.Type.ResourceFile");
    private static final String TYPE_EMBEDDED_IMAGE = Messages.getString((String)"ImageBuilder.Type.EmbededImage");
    private static final String TYPE_DYNAMIC_IMAGE = Messages.getString((String)"ImageBuilder.Type.DynamicImage");
    private static final String DLG_SELECT_PICTURE_LABEL = Messages.getString((String)"ImageBuilder.Label.SelectFrom");
    private static final String DLG_INSERT_BUTTON_MSG = Messages.getString((String)"ImageBuilder.Button.Insert");
    private static final String DLG_TITLE_IMPORT_FAIL = Messages.getString((String)"ImageBuilder.DialogTitle.ImportFailed");
    private static final String DLG_TITLE_LOADING_FAIL = Messages.getString((String)"ImageBuilder.DialogTitle.LoadingFailed");
    private static final String DLG_ERROR_MSG_LOADING_FAIL = Messages.getString((String)"ImageBuilder.ErrorMessage.LoadingFailed");
    private static final String DLG_ERROR_MSG_FILE_EXISTS = Messages.getString((String)"ImageBuilder.ErrorMessage.FileLoaded");
    private ImageHandle inputImage;
    private Button embedded;
    private Button uri;
    private Button dynamic;
    private Button resource;
    private Button inputButton;
    private Button importButton;
    private Composite inputArea;
    private Label description;
    private ImageCanvas previewCanvas;
    private Text uriEditor;
    private org.eclipse.swt.widgets.List embeddedImageList;
    private static final int URI_TYPE = 0;
    private static final int FILE_TYPE = 1;
    private static final int EMBEDDED_TYPE = 2;
    private static final int BLOB_TYPE = 3;
    private static final Map<Integer, String> descriptionMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> uriEditorLabelMap;
    private int selectedType = -1;
    private List dataSetList = new ArrayList();
    private List inputDataSetList = new ArrayList();
    private boolean hasInitDialog = false;
    private boolean isEditModel = false;
    private boolean hasModified = false;

    static {
        descriptionMap.put(0, Messages.getString((String)"ImageBuilder.Description.URI"));
        descriptionMap.put(1, Messages.getString((String)"ImageBuilder.Description.ResourceFile"));
        descriptionMap.put(2, Messages.getString((String)"ImageBuilder.Description.Embedded"));
        descriptionMap.put(3, Messages.getString((String)"ImageBuilder.Description.Dynamic"));
        uriEditorLabelMap = new HashMap<Integer, String>();
        uriEditorLabelMap.put(0, Messages.getString((String)"ImageBuilder.Label.EnterURI"));
        uriEditorLabelMap.put(1, Messages.getString((String)"ImageBuilder.Label.EnterResourceFile"));
        uriEditorLabelMap.put(3, Messages.getString((String)"ImageBuilder.Label.EnterExpr"));
    }

    public ImageBuilder(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public ImageBuilder(Shell parentShell, String title, List dataSetList) {
        super(parentShell, title);
        this.inputDataSetList = dataSetList;
        this.dataSetList = new ArrayList(this.inputDataSetList);
    }

    private ModuleHandle getModuleHandle() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle();
    }

    protected Control createDialogArea(Composite parent) {
        if (this.inputImage == null) {
            this.inputImage = DesignElementFactory.getInstance(this.getModuleHandle()).newImage(null);
            this.setOkButtonText(DLG_INSERT_BUTTON_MSG);
        }
        Composite topCompostie = (Composite)super.createDialogArea(parent);
        this.createSelectionArea(topCompostie);
        GridData topGd = new GridData(1808);
        int width = topCompostie.computeSize((int)-1, (int)-1).x;
        topGd.widthHint = width > 432 ? width : 432;
        topCompostie.setLayoutData((Object)topGd);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(topCompostie, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.description = new Label(composite, 0);
        this.description.setLayoutData((Object)new GridData(768));
        this.createInputArea(composite);
        this.createPreviewArea(composite);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ImageBuilder_ID");
        return topCompostie;
    }

    private void createSelectionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(DLG_SELECT_PICTURE_LABEL);
        label.setLayoutData((Object)new GridData(2));
        Composite selectionArea = new Composite(composite, 0);
        selectionArea.setLayout((Layout)new FillLayout(512));
        this.uri = new Button(selectionArea, 16);
        this.uri.setText(TYPE_URI);
        this.uri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(0);
                ImageBuilder.this.modifyDialogContent();
            }
        });
        this.resource = new Button(selectionArea, 16);
        this.resource.setText(TYPE_RESOURCE_FILE);
        this.resource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(1);
                ImageBuilder.this.modifyDialogContent();
            }
        });
        this.embedded = new Button(selectionArea, 16);
        this.embedded.setText(TYPE_EMBEDDED_IMAGE);
        this.embedded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(2);
                ImageBuilder.this.modifyDialogContent();
            }
        });
        this.dynamic = new Button(selectionArea, 16);
        this.dynamic.setText(TYPE_DYNAMIC_IMAGE);
        this.dynamic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(3);
                ImageBuilder.this.modifyDialogContent();
            }
        });
    }

    private void createInputArea(Composite parent) {
        this.inputArea = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.heightHint = 80;
        this.inputArea.setLayoutData((Object)gd);
        this.inputArea.setLayout((Layout)new GridLayout(3, false));
    }

    private void createPreviewArea(Composite composite) {
        Composite previewArea = new Composite(composite, 2048);
        GridData gd = new GridData();
        gd.heightHint = 240;
        gd.widthHint = 315;
        previewArea.setLayoutData((Object)gd);
        previewArea.setLayout((Layout)new FillLayout());
        this.previewCanvas = new ImageCanvas(previewArea);
    }

    private void switchTo(int type) {
        if (type == this.selectedType) {
            return;
        }
        this.selectedType = type;
        this.clearPreview();
        this.description.setText(descriptionMap.get(type));
        Control[] controls = this.inputArea.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        this.buildInputAreaUI(type);
        this.inputArea.layout();
    }

    private void buildInputAreaUI(int type) {
        if (type == 2) {
            this.buildEmbeddedImageList();
            this.buildInputAreaButton(type);
        } else {
            this.buildURIEditor(type);
            this.buildInputAreaButton(type);
            this.initURIEditor();
        }
    }

    private void buildURIEditor(int type) {
        Label uriEditorLabel = new Label(this.inputArea, 0);
        GridData labelGd = new GridData(768);
        labelGd.horizontalSpan = 3;
        uriEditorLabel.setLayoutData((Object)labelGd);
        uriEditorLabel.setText(uriEditorLabelMap.get(type));
        this.uriEditor = new Text(this.inputArea, 2052);
        GridData textGd = new GridData(768);
        this.uriEditor.setLayoutData((Object)textGd);
        this.uriEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImageBuilder.this.modifyDialogContent();
                ImageBuilder.this.updateButtons();
            }
        });
        this.uriEditor.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ImageBuilder.this.previewTextEditor();
            }
        });
    }

    private void previewTextEditor() {
        this.preview(this.getPreviewString());
    }

    private String getPreviewString() {
        String str = this.uriEditor.getText().trim();
        String type = (String)this.uriEditor.getData("exprType");
        if (!"constant".equals(type)) {
            str = DEUtil.removeQuote((String)str);
        }
        return str;
    }

    private void buildEmbeddedImageList() {
        this.embeddedImageList = new org.eclipse.swt.widgets.List(this.inputArea, 2820);
        this.embeddedImageList.setLayoutData((Object)new GridData(1808));
        this.embeddedImageList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageBuilder.this.preview();
                ImageBuilder.this.modifyDialogContent();
                ImageBuilder.this.updateButtons();
            }
        });
        this.initList();
    }

    public void setOpenFileButtonImage(Button button) {
        String imageName = "Open file";
        Image image = ReportPlatformUIImages.getImage(imageName);
        this.setButtonImage(button, image);
    }

    private void setButtonImage(Button button, Image image) {
        GridData gd = new GridData();
        if (!Platform.getOS().equals("macosx")) {
            gd.widthHint = 20;
            gd.heightHint = 20;
        }
        button.setLayoutData((Object)gd);
        button.setImage(image);
        if (button.getImage() != null) {
            button.getImage().setBackground(button.getBackground());
        }
    }

    private void buildInputAreaButton(int type) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ImageBuilder.this.modifyDialogContent();
                if (event.data instanceof String[]) {
                    ImageBuilder.this.preview(DEUtil.removeQuote((String)((String[])event.data)[1]));
                }
            }
        };
        if (type == 0) {
            ExpressionButtonUtil.createExpressionButton(this.inputArea, (Control)this.uriEditor, new ExpressionProvider((DesignElementHandle)this.inputImage), this.inputImage, listener, true, 8);
            new Label(this.inputArea, 0);
        } else if (type == 1) {
            this.inputButton = new Button(this.inputArea, 8);
            this.setOpenFileButtonImage(this.inputButton);
            this.inputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ImageBuilder.this.openResourceBrowser();
                }
            });
            this.inputButton.setToolTipText(BUTTON_BROWSE_TOOLTIP);
            ExpressionButtonUtil.createExpressionButton(this.inputArea, (Control)this.uriEditor, new ExpressionProvider((DesignElementHandle)this.inputImage), this.inputImage, listener, true, 8);
        } else if (type == 2) {
            this.importButton = new Button(this.inputArea, 8);
            this.importButton.setText(BUTTON_IMPORT);
            this.importButton.setLayoutData((Object)new GridData(8));
            this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileChooser = new FileDialog(ImageBuilder.this.getShell(), 4096);
                    fileChooser.setText(Messages.getString((String)"ImageBuilder.Chooser.Title"));
                    fileChooser.setFilterExtensions(IMAGE_FILEFILTERS);
                    try {
                        String fileName;
                        String fullPath = fileChooser.open();
                        if (fullPath != null && (fileName = fileChooser.getFileName()) != null) {
                            if (ImageBuilder.this.embeddedImageList.indexOf(fileName) != -1) {
                                ExceptionHandler.openMessageBox(DLG_TITLE_IMPORT_FAIL, DLG_ERROR_MSG_FILE_EXISTS, 8);
                                return;
                            }
                            if (!ImageBuilder.this.checkExtensions(fileName)) {
                                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Title"), Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Message"));
                                return;
                            }
                            ImageBuilder.this.previewCanvas.loadImage(ImageManager.getInstance().loadImage(ImageBuilder.this.inputImage.getModuleHandle(), fullPath));
                            BirtImageLoader imageLoader = new BirtImageLoader();
                            EmbeddedImage image = imageLoader.save(ImageBuilder.this.getModuleHandle(), fullPath, fileName);
                            ImageBuilder.this.embeddedImageList.add(image.getName());
                            ImageBuilder.this.embeddedImageList.select(ImageBuilder.this.embeddedImageList.indexOf(image.getName()));
                            ImageBuilder.this.hasModified = true;
                            ImageBuilder.this.updateButtons();
                        }
                    }
                    catch (Throwable e2) {
                        GUIException e2;
                        ImageBuilder.this.preview();
                        if (e2 instanceof OutOfMemoryError) {
                            e2 = GUIException.createGUIException((String)"org.eclipse.birt.report.designer.ui", (Throwable)e2);
                        }
                        ExceptionHandler.handle((Throwable)e2, DLG_TITLE_LOADING_FAIL, DLG_ERROR_MSG_LOADING_FAIL);
                    }
                }
            });
            new Label(this.inputArea, 0);
            new Label(this.inputArea, 0);
        } else if (type == 3) {
            this.inputButton = new Button(this.inputArea, 8);
            this.inputButton.setText(BUTTON_SELECT_IMAGE_DATA);
            this.inputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ImageBuilder.this.openBidingDialog();
                }
            });
            new Label(this.inputArea, 0);
            new Label(this.inputArea, 0);
        }
    }

    protected void openResourceBrowser() {
        ResourceSelectionValidator validator = new ResourceSelectionValidator(IMAGE_TYPES);
        ResourceFileFolderSelectionDialog dialog = new ResourceFileFolderSelectionDialog(true, true, IMAGE_FILEFILTERS);
        dialog.setAllowImportFile(true);
        dialog.setEmptyFolderShowStatus(2);
        dialog.setTitle(Messages.getString((String)"ImageBuilder.BrowserResourceDialog.Title"));
        dialog.setMessage(Messages.getString((String)"ImageBuilder.BrowserResourceDialog.Message"));
        dialog.setValidator(validator);
        if (dialog.open() == 0) {
            this.uriEditor.setText(dialog.getPath());
            this.uriEditor.setData("exprType", (Object)"constant");
            ((ExpressionButton)this.uriEditor.getData("exprButton")).refresh();
            this.uriEditor.setFocus();
            this.preview(dialog.getPath());
        }
    }

    private void preview(String uri) {
        if (uri == null || uri.trim().length() == 0) {
            this.clearPreview();
            return;
        }
        try {
            Image image = this.selectedType == 0 ? ImageManager.getInstance().getURIImage(this.inputImage.getModuleHandle(), uri) : ImageManager.getInstance().loadImage(this.inputImage.getModuleHandle(), uri);
            this.previewCanvas.loadImage(image);
        }
        catch (Exception e) {
            this.clearPreview();
            this.logger.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    private void preview() {
        if (this.embeddedImageList.getSelectionCount() > 0) {
            Image image = ImageManager.getInstance().getEmbeddedImage(this.inputImage.getModuleHandle(), this.embeddedImageList.getSelection()[0]);
            try {
                this.previewCanvas.loadImage(image);
                return;
            }
            catch (Exception e) {
                ExceptionHandler.handle(e, DLG_TITLE_LOADING_FAIL, DLG_ERROR_MSG_LOADING_FAIL);
            }
        }
        this.clearPreview();
    }

    private void clearPreview() {
        this.previewCanvas.clear();
    }

    protected void okPressed() {
        try {
            switch (this.selectedType) {
                case 1: {
                    this.inputImage.setFile(new Expression((Object)this.uriEditor.getText().trim(), (String)this.uriEditor.getData("exprType")));
                    break;
                }
                case 0: {
                    this.inputImage.setURL(new Expression((Object)this.uriEditor.getText().trim(), (String)this.uriEditor.getData("exprType")));
                    break;
                }
                case 2: {
                    this.inputImage.setImageName(this.embeddedImageList.getSelection()[0]);
                    break;
                }
                case 3: {
                    this.inputImage.setValueExpression(this.uriEditor.getText().trim());
                }
            }
            Image image = this.previewCanvas.getSourceImage();
            if (image != null) {
                if (DEUtil.isFixLayout((Object)this.getModuleHandle())) {
                    URL url;
                    String defaultUnit = this.getModuleHandle().getDefaultUnits();
                    InputStream in = null;
                    if (this.selectedType == 2) {
                        EmbeddedImage embeddedImage = this.getModuleHandle().findImage(this.embeddedImageList.getSelection()[0]);
                        in = new ByteArrayInputStream(embeddedImage.getData(this.getModuleHandle().getModule()));
                    } else if (this.selectedType == 0) {
                        url = ImageManager.getInstance().createURIURL(this.getPreviewString());
                        if (url != null) {
                            try {
                                in = url.openStream();
                            }
                            catch (IOException iOException) {}
                        }
                    } else if (this.selectedType == 1) {
                        try {
                            url = ImageManager.getInstance().generateURL(this.getModuleHandle(), this.getPreviewString());
                        }
                        catch (MalformedURLException e1) {
                            url = null;
                        }
                        if (url != null) {
                            try {
                                in = url.openStream();
                            }
                            catch (IOException e1) {
                                // empty catch block
                            }
                        }
                    }
                    int dpi = UIUtil.getImageResolution(in)[0];
                    if (dpi == 0 && this.getModuleHandle() instanceof ReportDesignHandle) {
                        dpi = ((ReportDesignHandle)this.getModuleHandle()).getImageDPI();
                    }
                    if (dpi == 0) {
                        dpi = UIUtil.getScreenResolution()[0];
                    }
                    int width = image.getBounds().width;
                    double inch = (double)width / (double)dpi;
                    DimensionValue value = DimensionUtil.convertTo((double)inch, (String)"in", (String)defaultUnit);
                    this.inputImage.getWidth().setValue((Object)value);
                    int height = image.getBounds().height;
                    inch = (double)height / (double)dpi;
                    value = DimensionUtil.convertTo((double)inch, (String)"in", (String)defaultUnit);
                    this.inputImage.getHeight().setValue((Object)value);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    this.inputImage.setWidth(image.getBounds().width + "px");
                    this.inputImage.setHeight(image.getBounds().height + "px");
                }
            }
            this.setResult(this.inputImage);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        super.okPressed();
    }

    public void setInput(Object input) {
        assert (input instanceof ImageHandle);
        this.inputImage = (ImageHandle)input;
        if ("none".equals(this.inputImage.getSource())) {
            this.setOkButtonText(DLG_INSERT_BUTTON_MSG);
        }
    }

    @Override
    protected boolean initDialog() {
        if ("embed".equals(this.inputImage.getSource())) {
            this.embedded.setSelection(true);
            this.switchTo(2);
        } else if ("expr".equals(this.inputImage.getSource())) {
            this.dynamic.setSelection(true);
            this.switchTo(3);
            this.initURIEditor();
        } else if ("file".equals(this.inputImage.getSource())) {
            this.resource.setSelection(true);
            this.switchTo(1);
            this.initURIEditor();
        } else {
            this.uri.setSelection(true);
            this.switchTo(0);
            this.initURIEditor();
        }
        this.hasInitDialog = true;
        return true;
    }

    public ExpressionHandle getURI() {
        return this.inputImage.getExpressionProperty("uri");
    }

    private void initURIEditor() {
        if (this.getURI() != null && this.selectedType == 0) {
            this.setURIEditor();
        }
        if (this.getURI() != null && this.selectedType == 1) {
            this.setURIEditor();
        }
        if (this.selectedType == 3 && this.inputImage.getValueExpression() != null) {
            this.uriEditor.setText(this.inputImage.getValueExpression());
        }
        this.uriEditor.setFocus();
        this.clearPreview();
        if (!this.uriEditor.getText().equals("") && this.selectedType != 3) {
            this.previewTextEditor();
        }
    }

    private void setURIEditor() {
        PropertyHandle uriPropertyHandle = this.inputImage.getPropertyHandle("uri");
        ExpressionHandle uri = this.getURI();
        if (uri != null) {
            this.uriEditor.setText(uri == null || uri.getExpression() == null ? "" : (String)uri.getExpression());
        }
        if (uriPropertyHandle != null && uriPropertyHandle.isLocal()) {
            this.uriEditor.setData("exprType", (Object)(uri == null || uri.getType() == null ? "constant" : uri.getType()));
        } else {
            this.uriEditor.setData("exprType", (Object)"constant");
        }
        ExpressionButton button = (ExpressionButton)this.uriEditor.getData("exprButton");
        if (button != null) {
            button.refresh();
        }
    }

    private void initList() {
        String imageName;
        for (EmbeddedImageHandle handle : this.getModuleHandle().getVisibleImages()) {
            this.embeddedImageList.add(handle.getQualifiedName());
        }
        int index = -1;
        if ("embed".equals(this.inputImage.getSource()) && (imageName = this.inputImage.getImageName()) != null) {
            index = this.embeddedImageList.indexOf(imageName);
        }
        if (index != -1) {
            this.embeddedImageList.select(index);
            this.preview();
        } else {
            this.clearPreview();
        }
        this.updateButtons();
    }

    private void updateButtons() {
        boolean complete = false;
        switch (this.selectedType) {
            case 3: {
                complete = !StringUtil.isBlank((String)this.uriEditor.getText());
                break;
            }
            case 0: {
                complete = !StringUtil.isBlank((String)this.uriEditor.getText());
                break;
            }
            case 2: {
                complete = this.embeddedImageList.getSelectionIndex() != -1;
                break;
            }
            case 1: {
                boolean bl = complete = !StringUtil.isBlank((String)this.uriEditor.getText());
            }
        }
        if (complete && !this.hasModified && this.isEditModal()) {
            complete = false;
        }
        this.getOkButton().setEnabled(complete);
    }

    private void openBidingDialog() {
        ImageHandle handle = this.inputImage;
        ColumnBindingDialog dialog = new ColumnBindingDialog((ReportItemHandle)handle, PlatformUI.getWorkbench().getDisplay().getActiveShell(), true);
        if (dialog.open() == 0) {
            Object obj = DEUtil.getFirstDataSource((DesignElementHandle)handle);
            String columnExpr = obj instanceof CubeHandle ? DEUtil.getDataExpression((String)((String)dialog.getResult())) : DEUtil.getColumnExpression((String)((String)dialog.getResult()));
            this.uriEditor.setText(columnExpr);
            try {
                this.inputImage.setValueExpression(this.uriEditor.getText().trim());
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private boolean checkExtensions(String fileName) {
        int i = 0;
        while (i < IMAGE_TYPES.length) {
            if (fileName.toLowerCase().endsWith(IMAGE_TYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setEditModal(boolean isEditModel) {
        this.isEditModel = isEditModel;
    }

    public boolean isEditModal() {
        return this.isEditModel;
    }

    protected void resetOkButtonStatus(boolean enabled) {
        Button okButton = this.getButton(0);
        if (okButton != null && okButton.isEnabled() != enabled) {
            okButton.setEnabled(enabled);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.isEditModal()) {
            this.resetOkButtonStatus(false);
        }
    }

    private void modifyDialogContent() {
        if (this.hasInitDialog && this.isEditModal() && !this.hasModified) {
            this.hasModified = true;
            this.updateButtons();
        }
    }
}

