/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.layer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;

public class TableGridLayer
extends GridLayer {
    private TableEditPart source;
    private Image img;
    private Dimension size = new Dimension();
    private Dimension propertySize = new Dimension();
    private double percentageHeight = 1.0;
    private double percentageWidth = 1.0;
    private int backgroundImageDPI = 0;

    public TableGridLayer(TableEditPart source) {
        this.source = source;
    }

    public List<?> getRows() {
        return this.source.getRows();
    }

    public List<?> getColumns() {
        return this.source.getColumns();
    }

    protected void paintGrid(Graphics g) {
        if (!this.getColumns().isEmpty()) {
            this.drawColumns(g);
        }
        if (!this.getRows().isEmpty()) {
            this.drawRows(g);
        }
    }

    protected void drawRows(Graphics g) {
        Rectangle clip = g.getClip(Rectangle.SINGLETON);
        List<?> rows = this.getRows();
        int size = rows.size();
        int height = 0;
        int i = 0;
        while (i < size) {
            int rowHeight = this.getRowHeight(rows.get(i));
            this.drawBackgroud(rows.get(i), g, clip.x, height, clip.x + clip.width, rowHeight);
            this.drawBackgroudImage((DesignElementHandle)rows.get(i), g, clip.x, height, clip.x + clip.width, rowHeight);
            height += rowHeight;
            ++i;
        }
    }

    private void drawBackgroudImage(DesignElementHandle handle, Graphics g, int x, int y, int width, int height) {
        String backGroundImage = this.getBackgroundImage(handle);
        if (backGroundImage != null) {
            Image image = null;
            String imageSourceType = "embed";
            Object obj = handle.getProperty("backgroundImageType");
            if (obj instanceof String) {
                imageSourceType = obj.toString();
            }
            try {
                image = imageSourceType.equalsIgnoreCase("embed") ? ImageManager.getInstance().getEmbeddedImage(this.source.getTableAdapter().getModuleHandle(), backGroundImage) : ImageManager.getInstance().getImage(this.source.getTableAdapter().getModuleHandle(), backGroundImage);
            }
            catch (SWTException e) {
                image = null;
            }
            if (image != null) {
                int ty;
                int tx;
                this.backgroundImageDPI = this.getImageDpi(backGroundImage);
                int pxBackgroundHeight = 0;
                int pxBackgroundWidth = 0;
                double percentageHeight = 1.0;
                double percentageWidth = 1.0;
                String propertyValue = handle.getStringProperty("backgroundSizeHeight");
                if (!(propertyValue == null || "auto".equals(propertyValue) || "cover".equals(propertyValue) || "contain".equals(propertyValue))) {
                    if (propertyValue.endsWith("%")) {
                        percentageHeight = Double.parseDouble(propertyValue.replace("%", "")) / 100.0;
                    } else {
                        DimensionValue propertyBackgroundHeight = (DimensionValue)handle.getProperty("backgroundSizeHeight");
                        if (propertyBackgroundHeight.getUnits().equals("px")) {
                            pxBackgroundHeight = (int)propertyBackgroundHeight.getMeasure();
                        } else {
                            DimensionValue backgroundHeight = DimensionUtil.convertTo((double)propertyBackgroundHeight.getMeasure(), (String)propertyBackgroundHeight.getUnits(), (String)"in");
                            pxBackgroundHeight = (int)MetricUtility.inchToPixel((double)backgroundHeight.getMeasure());
                        }
                    }
                }
                if (!((propertyValue = handle.getStringProperty("backgroundSizeWidth")) == null || "auto".equals(propertyValue) || "cover".equals(propertyValue) || "contain".equals(propertyValue))) {
                    if (propertyValue.endsWith("%")) {
                        percentageWidth = Double.parseDouble(propertyValue.replace("%", "")) / 100.0;
                    } else {
                        DimensionValue propertyBackgroundWidth = (DimensionValue)handle.getProperty("backgroundSizeWidth");
                        if (propertyBackgroundWidth.getUnits().equals("px")) {
                            pxBackgroundWidth = (int)propertyBackgroundWidth.getMeasure();
                        } else {
                            DimensionValue backgroundWidth = DimensionUtil.convertTo((double)propertyBackgroundWidth.getMeasure(), (String)propertyBackgroundWidth.getUnits(), (String)"in");
                            pxBackgroundWidth = (int)MetricUtility.inchToPixel((double)backgroundWidth.getMeasure());
                        }
                    }
                }
                this.setImage(image, pxBackgroundHeight, pxBackgroundWidth, percentageHeight, percentageWidth);
                Rectangle rectangle = new Rectangle(x, y, width, height);
                Object[] backGroundPosition = this.getBackgroundPosition(handle);
                int backGroundRepeat = this.getBackgroundRepeat(handle);
                Rectangle area = rectangle;
                int repeat = backGroundRepeat;
                int alignment = 0;
                Point position = new Point(-1, -1);
                Object xPosition = backGroundPosition[0];
                Object yPosition = backGroundPosition[1];
                org.eclipse.swt.graphics.Rectangle imageArea = image.getBounds();
                if (xPosition instanceof Integer) {
                    position.x = (Integer)xPosition;
                } else if (xPosition instanceof DimensionValue) {
                    int percentX = (int)((DimensionValue)xPosition).getMeasure();
                    position.x = (area.width - imageArea.width) * percentX / 100;
                } else if (xPosition instanceof String) {
                    alignment |= DesignElementHandleAdapter.getPosition((String)((String)xPosition));
                }
                if (yPosition instanceof Integer) {
                    position.y = (Integer)yPosition;
                } else if (yPosition instanceof DimensionValue) {
                    int percentY = (int)((DimensionValue)yPosition).getMeasure();
                    position.y = (area.height - imageArea.height) * percentY / 100;
                } else if (yPosition instanceof String) {
                    alignment |= DesignElementHandleAdapter.getPosition((String)((String)yPosition));
                }
                Dimension size = this.size;
                if (position != null && position.x != -1) {
                    tx = area.x + position.x;
                } else {
                    switch (alignment & 0x18) {
                        case 16: {
                            tx = area.x + area.width - size.width;
                            break;
                        }
                        case 8: {
                            tx = area.x;
                            break;
                        }
                        default: {
                            tx = (area.width - size.width) / 2 + area.x;
                        }
                    }
                }
                if (position != null && position.y != -1) {
                    ty = area.y + position.y;
                } else {
                    switch (alignment & 5) {
                        case 1: {
                            ty = area.y;
                            break;
                        }
                        case 4: {
                            ty = area.y + area.height - size.height;
                            break;
                        }
                        default: {
                            ty = (area.height - size.height) / 2 + area.y;
                        }
                    }
                }
                ArrayList<Point> xyList = this.createImageList(tx, ty, size, repeat, rectangle);
                Iterator<Point> iter = xyList.iterator();
                Rectangle rect = new Rectangle();
                g.getClip(rect);
                g.setClip(rectangle);
                Dimension imageSize = new Rectangle(image.getBounds()).getSize();
                while (iter.hasNext()) {
                    Point point = iter.next();
                    g.drawImage(image, 0, 0, imageSize.width, imageSize.height, point.x, point.y, size.width, size.height);
                }
                g.setClip(rect);
                xyList.clear();
            }
        }
    }

    private int getImageDpi(String backGroundImage) {
        if (this.source.getTableAdapter().getModuleHandle() == null) {
            return 0;
        }
        int dpi = 96;
        ModuleHandle model = this.source.getTableAdapter().getModuleHandle();
        InputStream in = null;
        URL temp = null;
        try {
            temp = URIUtil.isValidResourcePath((String)backGroundImage) ? ImageManager.getInstance().generateURL(model.getModuleHandle(), URIUtil.getLocalPath((String)backGroundImage)) : ImageManager.getInstance().generateURL(model.getModuleHandle(), backGroundImage);
            if (temp != null) {
                in = temp.openStream();
            }
        }
        catch (IOException e) {
            in = null;
        }
        dpi = UIUtil.getImageResolution(in)[0];
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
            }
        }
        return dpi;
    }

    private void setImage(Image image, int backGroundImageHeight, int backGroundImageWidth, double percentageHeight, double percentageWidth) {
        if (this.img == image && this.propertySize.height == backGroundImageHeight && this.propertySize.width == backGroundImageWidth && this.percentageHeight == percentageHeight && this.percentageWidth == percentageWidth) {
            return;
        }
        this.img = image;
        if (this.img != null) {
            this.propertySize.height = backGroundImageHeight;
            this.propertySize.width = backGroundImageWidth;
            this.percentageHeight = percentageHeight;
            this.percentageWidth = percentageWidth;
            if (this.backgroundImageDPI > 0 && backGroundImageHeight <= 0 && backGroundImageWidth > 0) {
                double inch = 1.0;
                inch = (double)image.getBounds().width / (double)this.backgroundImageDPI;
                int originalWidth = (int)MetricUtility.inchToPixel((double)inch);
                double scaleFactor = (double)backGroundImageWidth / (double)originalWidth;
                inch = (double)image.getBounds().height / (double)this.backgroundImageDPI;
                this.size.height = (int)(MetricUtility.inchToPixel((double)inch) * scaleFactor);
                this.size.width = backGroundImageWidth;
            } else if (this.backgroundImageDPI > 0 && backGroundImageWidth <= 0 && backGroundImageHeight > 0) {
                double inch = 1.0;
                inch = (double)image.getBounds().height / (double)this.backgroundImageDPI;
                int originalHeight = (int)MetricUtility.inchToPixel((double)inch);
                double scaleFactor = (double)backGroundImageHeight / (double)originalHeight;
                inch = (double)image.getBounds().width / (double)this.backgroundImageDPI;
                this.size.width = (int)(MetricUtility.inchToPixel((double)inch) * scaleFactor);
                this.size.height = backGroundImageHeight;
            } else if (this.backgroundImageDPI > 0 && backGroundImageHeight <= 0 && backGroundImageWidth <= 0) {
                double inch = (double)image.getBounds().width / (double)this.backgroundImageDPI;
                this.size.width = (int)MetricUtility.inchToPixel((double)inch);
                inch = (double)image.getBounds().height / (double)this.backgroundImageDPI;
                this.size.height = (int)MetricUtility.inchToPixel((double)inch);
            } else if (backGroundImageHeight > 0 && backGroundImageWidth > 0) {
                this.size.height = backGroundImageHeight;
                this.size.width = backGroundImageWidth;
            } else {
                this.size = new Rectangle(image.getBounds()).getSize();
            }
        } else {
            this.size = new Dimension();
        }
        if (percentageHeight != 1.0 && percentageWidth == 1.0 && backGroundImageWidth == 0) {
            percentageWidth = percentageHeight;
        } else if (percentageWidth != 1.0 && percentageHeight == 1.0 && backGroundImageHeight == 0) {
            percentageHeight = percentageWidth;
        }
        this.size.height = (int)((double)this.size.height * percentageHeight);
        this.size.width = (int)((double)this.size.width * percentageWidth);
        this.revalidate();
        this.repaint();
    }

    private ArrayList<Point> createImageList(int x, int y, Dimension size, int repeat, Rectangle rectangle) {
        Rectangle area = rectangle;
        ArrayList<Point> yList = new ArrayList<Point>();
        if ((repeat & 2) == 0) {
            yList.add(new Point(x, y));
        } else {
            int i = 0;
            while (y + size.height * i + size.height > area.y) {
                yList.add(new Point(x, y + size.height * i));
                --i;
            }
            i = 1;
            while (y + size.height * i < area.y + area.height) {
                yList.add(new Point(x, y + size.height * i));
                ++i;
            }
        }
        ArrayList<Point> xyList = new ArrayList<Point>();
        for (Point point : yList) {
            if ((repeat & 1) == 0) {
                xyList.add(point);
                continue;
            }
            int i = 0;
            while (point.x + size.width * i + size.width > area.x) {
                xyList.add(new Point(point.x + size.width * i, point.y));
                --i;
            }
            i = 1;
            while (point.x + size.width * i < area.x + area.width) {
                xyList.add(new Point(point.x + size.width * i, point.y));
                ++i;
            }
        }
        yList.clear();
        return xyList;
    }

    private RowHandleAdapter getRowAdapter(DesignElementHandle handle) {
        return HandleAdapterFactory.getInstance().getRowHandleAdapter((Object)handle);
    }

    private ColumnHandleAdapter getColumnAdapter(DesignElementHandle handle) {
        return HandleAdapterFactory.getInstance().getColumnHandleAdapter((Object)handle);
    }

    private String getBackgroundImage(DesignElementHandle handle) {
        if (handle instanceof RowHandle && this.getRowAdapter(handle) != null) {
            return this.getRowAdapter(handle).getBackgroundImage(handle);
        }
        if (handle instanceof ColumnHandle && this.getColumnAdapter(handle) != null) {
            return this.getColumnAdapter(handle).getBackgroundImage(handle);
        }
        return "";
    }

    private Object[] getBackgroundPosition(DesignElementHandle handle) {
        if (handle instanceof RowHandle && this.getRowAdapter(handle) != null) {
            return this.getRowAdapter(handle).getBackgroundPosition(handle);
        }
        if (handle instanceof ColumnHandle && this.getColumnAdapter(handle) != null) {
            return this.getColumnAdapter(handle).getBackgroundPosition(handle);
        }
        return new Object[2];
    }

    private int getBackgroundRepeat(DesignElementHandle handle) {
        if (handle instanceof RowHandle && this.getRowAdapter(handle) != null) {
            return this.getRowAdapter(handle).getBackgroundRepeat(handle);
        }
        if (handle instanceof ColumnHandle && this.getColumnAdapter(handle) != null) {
            return this.getColumnAdapter(handle).getBackgroundRepeat(handle);
        }
        return 0;
    }

    protected void drawColumns(Graphics g) {
        g.setBackgroundColor(ReportColorConstants.greyFillColor);
        Rectangle clip = g.getClip(Rectangle.SINGLETON);
        List<?> columns = this.getColumns();
        int size = columns.size();
        int width = 0;
        int i = 0;
        while (i < size) {
            int columnWidth = this.getColumnWidth(i + 1, columns.get(i));
            this.drawBackgroud(columns.get(i), g, width, clip.y, columnWidth, clip.y + clip.height);
            this.drawBackgroudImage((DesignElementHandle)columns.get(i), g, width, clip.y, columnWidth, clip.y + clip.height);
            width += columnWidth;
            ++i;
        }
    }

    private int getRowHeight(Object row) {
        return TableUtil.caleVisualHeight(this.source, row);
    }

    private int getColumnWidth(int columnIndex, Object column) {
        return TableUtil.caleVisualWidth(this.source, columnIndex, column);
    }

    private void drawBackgroud(Object model, Graphics g, int x, int y, int width, int height) {
        assert (model instanceof DesignElementHandle);
        DesignElementHandle handle = (DesignElementHandle)model;
        Object obj = handle.getProperty("backgroundColor");
        if (obj != null) {
            Rectangle rect = new Rectangle(x, y, width, height);
            int color = handle.getPropertyHandle("backgroundColor").getIntValue();
            g.setBackgroundColor(ColorManager.getColor((int)color));
            g.fillRectangle(rect);
        }
    }
}

