/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.LabelEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.LabelFigure;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.bidi.BidiUIUtils;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;

public class DataEditPart
extends LabelEditPart {
    private static final String FIGURE_DEFAULT_TEXT = Messages.getString((String)"DataEditPart.Figure.Dafault");
    protected static final String AGGREGATE_ON = Messages.getString((String)"DataEditPart.text.AggregateOn");
    protected static final String PREFIX = "\u2211";

    public DataEditPart(Object model) {
        super(model);
    }

    @Override
    protected IFigure createFigure() {
        LabelFigure label = new LabelFigure();
        label.setLayoutManager((LayoutManager)new StackLayout());
        return label;
    }

    @Override
    public void performDirectEdit() {
        DataItemHandle handle = (DataItemHandle)this.getModel();
        handle.getModuleHandle().getCommandStack().startTrans(Messages.getString((String)"DataEditPart.stackMsg.edit"));
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(handle.getResultSetColumn() == null);
        dialog.setEditModal(true);
        if (handle.getResultSetColumn() != null) {
            dialog.setInput((ReportItemHandle)handle, DEUtil.getInputBinding((ReportItemHandle)handle, (String)handle.getResultSetColumn()));
        } else {
            dialog.setInput((ReportItemHandle)handle);
        }
        if (dialog.open() == 0) {
            try {
                if (dialog.getBindingColumn() != null) {
                    handle.setResultSetColumn(dialog.getBindingColumn().getName());
                }
                handle.getModuleHandle().getCommandStack().commit();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
                handle.getModuleHandle().getCommandStack().rollbackAll();
            }
            this.refreshVisuals();
        } else {
            handle.getModuleHandle().getCommandStack().rollbackAll();
        }
    }

    @Override
    public void refreshFigure() {
        super.refreshFigure();
        ((LabelFigure)this.getFigure()).setToolTipText(((DataItemHandle)this.getModel()).getResultSetColumn());
    }

    @Override
    protected String getText() {
        Object text = ((DataItemHandle)this.getModel()).getResultSetColumn();
        if (text == null || ((String)text).length() == 0) {
            text = FIGURE_DEFAULT_TEXT;
        } else {
            String displayName = this.getDisplayName();
            if (displayName != null && displayName.length() > 0) {
                text = displayName;
            }
            if (((String)text).length() > 18) {
                text = ((String)text).substring(0, 16) + "...";
            }
            text = BidiUIUtils.INSTANCE.isDirectionRTL(this.getModel()) ? "\u202a[\u202b" + (String)text + "\u202c]\u202c" : "[" + (String)text + "]";
        }
        if (this.hasBindingFunction()) {
            ((LabelFigure)this.getFigure()).setSpecialPREFIX(PREFIX);
            text = PREFIX + (String)text;
        }
        return text;
    }

    protected boolean hasBindingFunction() {
        DataItemHandle handle = (DataItemHandle)this.getModel();
        String name = handle.getResultSetColumn();
        if (name == null) {
            return false;
        }
        ComputedColumnHandle bindingColumn = DEUtil.getInputBinding((ReportItemHandle)handle, (String)name);
        if (bindingColumn == null) {
            return false;
        }
        return bindingColumn.getAggregateFunction() != null;
    }

    protected String getDisplayName() {
        DataItemHandle handle = (DataItemHandle)this.getModel();
        String name = handle.getResultSetColumn();
        if (name == null) {
            return null;
        }
        ComputedColumnHandle bindingColumn = DEUtil.getInputBinding((ReportItemHandle)handle, (String)name);
        if (bindingColumn == null) {
            return null;
        }
        String displayName = null;
        displayName = bindingColumn.getDisplayName() == null && bindingColumn.getDisplayNameID() != null ? bindingColumn.getExternalizedValue("displayNameID", "displayName") : bindingColumn.getDisplayName();
        if (displayName == null) {
            displayName = bindingColumn.getColumnName();
        }
        return displayName;
    }

    @Override
    protected boolean hasText() {
        String text = ((DataItemHandle)this.getModel()).getResultSetColumn();
        return text != null && text.length() > 0;
    }
}

