/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.validators.AbstractPropertyValidator;

public class ValueRequiredValidator
extends AbstractPropertyValidator {
    public static final String NAME = "ValueRequiredValidator";
    private static ValueRequiredValidator instance = new ValueRequiredValidator();

    public static ValueRequiredValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element, String propName) {
        DesignElement e = element;
        while (e != null) {
            if (e instanceof TemplateParameterDefinition) {
                return Collections.emptyList();
            }
            e = e.getContainer();
        }
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        Object value = element.getProperty(module, propName);
        if (value == null || value instanceof String && StringUtil.isBlank((String)value) || value instanceof Expression && ((Expression)value).getExpression() == null) {
            list.add(new PropertyValueException(element, propName, value, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }
}

