/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.dataextraction.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IDataExtractionOption;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.dataextraction.CSVDataExtractionOption;
import org.eclipse.birt.report.engine.dataextraction.ICSVDataExtractionOption;
import org.eclipse.birt.report.engine.dataextraction.csv.CSVUtil;
import org.eclipse.birt.report.engine.dataextraction.i18n.Messages;
import org.eclipse.birt.report.engine.dataextraction.impl.CommonDataExtractionImpl;

public class CSVDataExtractionImpl
extends CommonDataExtractionImpl {
    public static final String PLUGIN_ID = "org.eclipse.birt.report.engine.dataextraction.csv";
    public static final String DEFAULT_ENCODING = Charset.defaultCharset().name();
    private OutputStream outputStream;
    private String encoding;
    private String sep;
    private boolean addCR;
    private boolean isExportDataType;
    private boolean isExportColumnHeader;
    private String[] selectedColumnNames;
    private int columnLocalizeOption;

    public void initialize(IReportContext context, IDataExtractionOption options) throws BirtException {
        super.initialize(context, options);
        this.initCsvOptions(options);
    }

    private void initCsvOptions(IDataExtractionOption options) {
        this.outputStream = options.getOutputStream();
        Object csvOptions = options instanceof ICSVDataExtractionOption ? (ICSVDataExtractionOption)options : new CSVDataExtractionOption(options.getOptions());
        this.encoding = csvOptions.getEncoding();
        this.encoding = this.encoding == null || "".equals(this.encoding.trim()) ? null : this.encoding.trim();
        if (this.encoding == null) {
            this.encoding = DEFAULT_ENCODING;
        }
        this.sep = csvOptions.getSeparator();
        if (this.sep == null || "".equals(this.sep)) {
            this.sep = ",";
        }
        this.addCR = csvOptions.getAddCR();
        this.isExportDataType = csvOptions.isExportDataType();
        this.isExportColumnHeader = csvOptions.isExportColumnHeader();
        this.selectedColumnNames = csvOptions.getSelectedColumns();
        this.columnLocalizeOption = csvOptions.getColumnLocalizeOption();
    }

    public void output(IExtractionResults results) throws BirtException {
        if (results == null) {
            throw new BirtException(PLUGIN_ID, Messages.getString((String)"exception.dataextraction.no_extraction_result_error"), null);
        }
        try {
            String[] columnNames = null;
            String[] columnLabels = null;
            IResultMetaData metaData = results.getResultMetaData();
            int count = metaData.getColumnCount();
            if (this.selectedColumnNames == null || this.selectedColumnNames.length <= 0) {
                columnNames = new String[count];
                columnLabels = new String[count];
                int i = 0;
                while (i < count) {
                    String colName;
                    columnNames[i] = colName = metaData.getColumnName(i);
                    columnLabels[i] = metaData.getColumnLabel(i);
                    ++i;
                }
            } else {
                HashMap<String, String> nameLabelMap = new HashMap<String, String>();
                int i = 0;
                while (i < count) {
                    String colName = metaData.getColumnName(i);
                    String colLabel = metaData.getColumnLabel(i);
                    nameLabelMap.put(colName, colLabel);
                    ++i;
                }
                int selectedCount = this.selectedColumnNames.length;
                ArrayList<String> labelList = new ArrayList<String>();
                ArrayList<String> nameList = new ArrayList<String>();
                int i2 = 0;
                while (i2 < selectedCount) {
                    String label = (String)nameLabelMap.get(this.selectedColumnNames[i2]);
                    if (label != null) {
                        nameList.add(this.selectedColumnNames[i2]);
                        labelList.add(label);
                    }
                    ++i2;
                }
                columnLabels = labelList.toArray(new String[0]);
                columnNames = nameList.toArray(new String[0]);
            }
            IDataIterator iData = null;
            if (results != null && (iData = results.nextResultIterator()) != null && columnNames.length > 0) {
                if (this.isExportColumnHeader) {
                    if ((this.columnLocalizeOption & 1) != 0) {
                        this.output(CSVUtil.makeCSVRow(columnNames, this.sep, this.addCR));
                    }
                    if ((this.columnLocalizeOption & 2) != 0) {
                        this.output(CSVUtil.makeCSVRow(columnLabels, this.sep, this.addCR));
                    }
                }
                int[] columnTypes = this.getColumnTypes(columnNames, results);
                if (this.isExportDataType) {
                    this.output(this.makeDataTypesRow(columnTypes));
                }
                String[] values = new String[columnNames.length];
                this.createFormatters(columnNames, columnTypes);
                while (iData.next()) {
                    int i = 0;
                    while (i < columnNames.length) {
                        if (columnTypes[i] != 7 && columnTypes[i] != 8) {
                            System.out.println("getStringValue(iData, columnNames, i): " + this.getStringValue(iData, columnNames, i));
                            values[i] = this.getStringValue(iData, columnNames, i);
                        } else {
                            values[i] = null;
                        }
                        ++i;
                    }
                    this.output(CSVUtil.makeCSVRow(values, this.sep, this.addCR));
                }
            }
        }
        catch (Exception e) {
            throw new BirtException(PLUGIN_ID, Messages.getString((String)"exception.dataextraction.exception_occured"), null, (Throwable)e);
        }
    }

    private String makeDataTypesRow(int[] types) {
        String[] values = new String[types.length];
        int i = 0;
        while (i < types.length) {
            values[i] = DataType.getName((int)types[i]);
            ++i;
        }
        return CSVUtil.makeCSVRow(values, this.sep, this.addCR);
    }

    private int[] getColumnTypes(String[] columnNames, IExtractionResults results) throws BirtException {
        HashMap<String, Integer> typesMap = new HashMap<String, Integer>();
        int count = results.getResultMetaData().getColumnCount();
        int i = 0;
        while (i < count) {
            String colName = results.getResultMetaData().getColumnName(i);
            int colType = results.getResultMetaData().getColumnType(i);
            typesMap.put(colName, colType);
            ++i;
        }
        int[] types = new int[columnNames.length];
        int i2 = 0;
        while (i2 < columnNames.length) {
            Integer colType = (Integer)typesMap.get(columnNames[i2]);
            if (colType == null) {
                throw new BirtException("The specified column \"" + columnNames[i2] + "\" does not exist in the result set!");
            }
            types[i2] = colType;
            ++i2;
        }
        return types;
    }

    private void output(String s) throws IOException, UnsupportedEncodingException {
        this.outputStream.write(s.getBytes(this.encoding));
    }
}

