/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.extension;

import org.eclipse.birt.report.designer.ui.extensions.IReportItemFigureProvider;
import org.eclipse.birt.report.designer.ui.extensions.IReportItemImageProvider;
import org.eclipse.birt.report.designer.ui.extensions.IReportItemLabelProvider;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Image;

public class ExtendedUIAdapter
implements IReportItemFigureProvider {
    private IReportItemFigureProvider figureExtension;
    private IReportItemImageProvider imageExtension;
    private IReportItemLabelProvider labelExtension;
    private int extensionType;
    private static final int FIGURE_EXTENSION_TYPE = 0;
    private static final int IMAGE_EXTENSION_TYPE = 1;
    private static final int LABEL_EXTENSION_TYPE = 2;

    public ExtendedUIAdapter(Object extension) {
        if (extension instanceof IReportItemFigureProvider) {
            this.figureExtension = (IReportItemFigureProvider)extension;
            this.extensionType = 0;
        } else if (extension instanceof IReportItemImageProvider) {
            this.imageExtension = (IReportItemImageProvider)extension;
            this.extensionType = 1;
        } else if (extension instanceof IReportItemLabelProvider) {
            this.labelExtension = (IReportItemLabelProvider)extension;
            this.extensionType = 2;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public IFigure createFigure(ExtendedItemHandle handle) {
        switch (this.extensionType) {
            case 0: {
                return this.figureExtension.createFigure(handle);
            }
            case 1: {
                return new ImageFigure(this.imageExtension.getImage(handle));
            }
            case 2: {
                return new Label(this.labelExtension.getLabel(handle));
            }
        }
        return null;
    }

    @Override
    public void updateFigure(ExtendedItemHandle handle, IFigure figure) {
        switch (this.extensionType) {
            case 0: {
                this.figureExtension.updateFigure(handle, figure);
                break;
            }
            case 1: {
                ImageFigure imageFigure = (ImageFigure)figure;
                Image newImage = this.imageExtension.getImage(handle);
                Image oldImage = imageFigure.getImage();
                if (newImage == oldImage) break;
                imageFigure.setImage(newImage);
                this.imageExtension.disposeImage(handle, oldImage);
                break;
            }
            case 2: {
                ((Label)figure).setText(this.labelExtension.getLabel(handle));
            }
        }
    }

    @Override
    public void disposeFigure(ExtendedItemHandle handle, IFigure figure) {
        switch (this.extensionType) {
            case 0: {
                this.figureExtension.disposeFigure(handle, figure);
                break;
            }
            case 1: {
                this.imageExtension.disposeImage(handle, ((ImageFigure)figure).getImage());
                break;
            }
        }
    }
}

